      double precision function xmnargusr2(wpar,dpx,dexpmx)
*-----------------------------------------------------------------------
*     Reversed ARGUS background function
*
*     $Id: xmnargusr2.fpp,v 1.1 2005/09/08 12:43:36 brock Exp $
*-----------------------------------------------------------------------
*
      implicit none
*
      double precision wpar(*),dpx,dexpmx
*
      double precision dz1, dz2, dz3
*
      xmnargusr2 = 0.0d0
      dz1 = (dpx + wpar(2))
      dz2 = 0.0d0
      if(wpar(3).gt.0.0d0) dz2 = (dz1 / wpar(3))**2 - 1.0d0
      dz3 = wpar(4)*dz2
      if(dz1.ge.0.0d0 .and. dz2.ge.0.0d0 .and.
     + dabs(dz3).le.dexpmx) then
          xmnargusr2 = wpar(1) * dz1 * dsqrt(dz2) * dexp(dz3)
      endif
*
      end
