//  $Id: mmdb_bondmngr.cpp,v 1.5 2004/05/17 16:38:13 keb Exp $
//  =================================================================
//
//   CCP4 Coordinate Library: support of coordinate-related
//   functionality in protein crystallography applications.
//
//   Copyright (C) Eugene Krissinel 2004.
//
//   This library is free software and is distributed under the terms
//   and conditions of the CCP4 licence agreement as `Part 0' (Annex 2)
//   software, which is version 2.1 of the GNU Lesser General Public
//   Licence (LGPL) with the following additional clause:
//
//      `You may also combine or link a "work that uses the Library"
//      to produce a work containing portions of the Library, and
//      distribute that work under terms of your choice, provided that
//      you give prominent notice with each copy of the work that the
//      specified version of the Library is used in it, and that you
//      include or provide public access to the complete corresponding
//      machine-readable source code for the Library including whatever
//      changes were used in the work. (i.e. If you make changes to the
//      Library you must distribute those, but you do not need to
//      distribute source or object code to those portions of the work
//      not covered by this licence.)'
//
//   Note that this clause grants an additional right and does not
//   impose any additional restriction, and so does not affect
//   compatibility with the GNU General Public Licence (GPL). If you
//   wish to negotiate other terms, please contact the maintainer.
//
//   You can redistribute it and/or modify the library under the terms
//   of the GNU Lesser General Public License as published by the Free
//   Software Foundation; either version 2.1 of the License, or (at
//   your option) any later version.
//
//   This library is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Lesser General Public License for more details.
//
//   You should have received a copy of the CCP4 licence and/or GNU
//   Lesser General Public License along with this library; if not,
//   write to the CCP4 Secretary, Daresbury Laboratory, Warrington
//   WA4 4AD, UK. The GNU Lesser General Public can also be obtained
//   by writing to the Free Software Foundation, Inc., 59 Temple Place,
//   Suite 330, Boston, MA 02111-1307 USA
//
//  =================================================================
//
//    12.01.01   <--  Date of Last Modification.
//                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  -----------------------------------------------------------------
//
//  **** Module  :  mmdb_bondmngr  <implementation>
//       ~~~~~~~~~
//  **** Project :  MacroMolecular Data Base (MMDB)
//       ~~~~~~~~~
//  **** Classes :  CMMDBBondManager ( MMDB bonds maker )
//       ~~~~~~~~~
//
//  E. Krissinel 2000-2002
//
//  =================================================================
//


#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __MMDB_BondMngr__
#include "mmdb_bondmngr.h"
#endif

#ifndef  __MMDB_Graph__
#include "mmdb_graph.h"
#endif


//  =====================   CMMDBBondManager   =====================

CMMDBBondManager::CMMDBBondManager() : CMMDBSelManager()  {
}

CMMDBBondManager::CMMDBBondManager ( RPCStream Object )
                : CMMDBSelManager(Object)  {
}

CMMDBBondManager::~CMMDBBondManager()  {}

void  CMMDBBondManager::MakeBonds ( Boolean calc_only )  {
PCModel   model;
PCChain   chain;
PCResidue res;
CGraph    graph;
PPCVertex V;
PPCEdge   E;
int       i, im,ic,ir, nV,nE, k1,k2;

  RemoveBonds();

  for (im=0;im<nModels;im++)  {
    model = Model[im];
    if (model)
      for (ic=0;ic<model->nChains;ic++)  {
        chain = model->Chain[ic];
        if (chain)
          for (ir=0;ir<chain->nResidues;ir++)  {
            res = chain->Residue[ir];
            if (res)  {
              graph.MakeGraph   ( res,NULL );
              graph.GetVertices ( V,nV );
              graph.GetEdges    ( E,nE );
              for (i=0;i<nE;i++)  {
                k1 = V[E[i]->GetVertex1()]->GetUserID();
                k2 = V[E[i]->GetVertex2()]->GetUserID();
                res->atom[k1]->AddBond ( res->atom[k2],E[i]->GetType() );
                res->atom[k2]->AddBond ( res->atom[k1],E[i]->GetType() );
              }
            }
          }
      }
  }

}

void  CMMDBBondManager::RemoveBonds()  {
int i;
  for (i=0;i<nAtoms;i++)
    if (Atom[i])
      Atom[i]->FreeBonds();
}

//  -------------------  Stream functions  ----------------------

void  CMMDBBondManager::write ( RCFile f )  {
byte Version=1;
  f.WriteByte ( &Version );
  CMMDBSelManager::write ( f );
}

void  CMMDBBondManager::read ( RCFile f )  {
byte Version;
  f.ReadByte ( &Version );
  CMMDBSelManager::read ( f );
}


MakeStreamFunctions(CMMDBBondManager)
