# -------------------------------------------------------------------------
#     Copyright (C) 2005-2010 Martin Strohalm <www.mmass.org>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 3 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE.TXT in the
#     main directory of the program
# -------------------------------------------------------------------------

# load libs
import wx
from wx.tools import img2py

import ids


# IMAGES
# ------

lib = {}

def loadImages():
    """Load images from lib."""
    
    # load image library
    if wx.Platform == '__WXMAC__':
        import images_lib_mac as images_lib
    elif wx.Platform == '__WXMSW__':
        import images_lib_msw as images_lib
    else:
        import images_lib_gtk as images_lib
    
    # common
    lib['icon16'] = images_lib.getIcon16Icon()
    lib['icon32'] = images_lib.getIcon32Icon()
    lib['icon48'] = images_lib.getIcon48Icon()
    lib['icon128'] = images_lib.getIcon128Icon()
    lib['icon256'] = images_lib.getIcon256Icon()
    lib['icon512'] = images_lib.getIcon512Icon()
    
    lib['iconAbout'] = images_lib.getIconAboutBitmap()
    lib['iconError'] = images_lib.getIconErrorBitmap()
    lib['iconDlg'] = images_lib.getIconDlgBitmap()
    
    # cursors
    cursors = images_lib.getCursorsBitmap()
    image = cursors.GetSubBitmap(wx.Rect(0, 0, 16, 16)).ConvertToImage()
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_X, 0)
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_Y, 0)
    lib['cursorArrow'] = wx.CursorFromImage(image)
    image = cursors.GetSubBitmap(wx.Rect(16, 0, 16, 16)).ConvertToImage()
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_X, 0)
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_Y, 0)
    lib['cursorArrowMeasure'] = wx.CursorFromImage(image)
    image = cursors.GetSubBitmap(wx.Rect(32, 0, 16, 16)).ConvertToImage()
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_X, 0)
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_Y, 0)
    lib['cursorArrowPeak'] = wx.CursorFromImage(image)
    image = cursors.GetSubBitmap(wx.Rect(48, 0, 16, 16)).ConvertToImage()
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_X, 0)
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_Y, 0)
    lib['cursorArrowPoint'] = wx.CursorFromImage(image)
    image = cursors.GetSubBitmap(wx.Rect(64, 0, 16, 16)).ConvertToImage()
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_X, 0)
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_Y, 0)
    lib['cursorArrowDelete'] = wx.CursorFromImage(image)
    image = cursors.GetSubBitmap(wx.Rect(0, 0, 16, 16)).ConvertToImage()
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_X, 0)
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_Y, 0)
    lib['cursorCross'] = wx.CursorFromImage(image)
    image = cursors.GetSubBitmap(wx.Rect(16, 16, 16, 16)).ConvertToImage()
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_X, 7)
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_Y, 7)
    lib['cursorCrossMeasure'] = wx.CursorFromImage(image)
    image = cursors.GetSubBitmap(wx.Rect(32, 16, 16, 16)).ConvertToImage()
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_X, 7)
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_Y, 7)
    lib['cursorCrossPeak'] = wx.CursorFromImage(image)
    image = cursors.GetSubBitmap(wx.Rect(48, 16, 16, 16)).ConvertToImage()
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_X, 7)
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_Y, 7)
    lib['cursorCrossPoint'] = wx.CursorFromImage(image)
    image = cursors.GetSubBitmap(wx.Rect(64, 16, 16, 16)).ConvertToImage()
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_X, 7)
    image.SetOptionInt(wx.IMAGE_OPTION_CUR_HOTSPOT_Y, 7)
    lib['cursorCrossDelete'] = wx.CursorFromImage(image)
    
    # arrows
    arrows = images_lib.getArrowsBitmap()
    lib['arrowUp'] = arrows.GetSubBitmap(wx.Rect(0, 0, 11, 11))
    lib['arrowRight'] = arrows.GetSubBitmap(wx.Rect(11, 0, 11, 11))
    lib['arrowDown'] = arrows.GetSubBitmap(wx.Rect(22, 0, 11, 11))
    lib['arrowLeft'] = arrows.GetSubBitmap(wx.Rect(33, 0, 11, 11))
    
    # backgrounds
    lib['bgrToolbar'] = images_lib.getBgrToolbarBitmap()
    lib['bgrToolbarNoBorder'] = images_lib.getBgrToolbarNoBorderBitmap()
    lib['bgrControlbar'] = images_lib.getBgrControlbarBitmap()
    lib['bgrBottombar'] = images_lib.getBgrBottombarBitmap()
    lib['bgrPeakEditor'] = images_lib.getBgrPeakEditorBitmap()
    
    # bullets
    bulletsOn = images_lib.getBulletsOnBitmap()
    bulletsOff = images_lib.getBulletsOffBitmap()
    lib['bulletDocuments'] = bulletsOn.GetSubBitmap(wx.Rect(0, 0, 13, 12))
    lib['bulletAnnotationsOn'] = bulletsOn.GetSubBitmap(wx.Rect(13, 0, 13, 12))
    lib['bulletAnnotationsOff'] = bulletsOff.GetSubBitmap(wx.Rect(13, 0, 13, 12))
    lib['bulletSequenceOn'] = bulletsOn.GetSubBitmap(wx.Rect(26, 0, 13, 12))
    lib['bulletSequenceOff'] = bulletsOff.GetSubBitmap(wx.Rect(26, 0, 13, 12))
    lib['bulletMatchOn'] = bulletsOn.GetSubBitmap(wx.Rect(39, 0, 13, 12))
    lib['bulletMatchOff'] = bulletsOff.GetSubBitmap(wx.Rect(39, 0, 13, 12))
    
    # tools
    if wx.Platform == '__WXMAC__':
        tools = images_lib.getToolsBitmap()
        lib['toolProcessing'] = tools.GetSubBitmap(wx.Rect(0, 0, 30, 22))
        lib['toolCalibration'] = tools.GetSubBitmap(wx.Rect(30, 0, 30, 22))
        lib['toolSequence'] = tools.GetSubBitmap(wx.Rect(60, 0, 30, 22))
        lib['toolMasscalc'] = tools.GetSubBitmap(wx.Rect(90, 0, 30, 22))
        lib['toolCompounds'] = tools.GetSubBitmap(wx.Rect(120, 0, 30, 22))
        lib['toolDifferences'] = tools.GetSubBitmap(wx.Rect(150, 0, 30, 22))
        lib['toolCompare'] = tools.GetSubBitmap(wx.Rect(180, 0, 30, 22))
        lib['toolMascot'] = tools.GetSubBitmap(wx.Rect(210, 0, 30, 22))
        lib['toolProfound'] = tools.GetSubBitmap(wx.Rect(240, 0, 30, 22))
        lib['toolInfo'] = tools.GetSubBitmap(wx.Rect(270, 0, 30, 22))
        lib['toolReport'] = tools.GetSubBitmap(wx.Rect(300, 0, 30, 22))
        lib['toolExport'] = tools.GetSubBitmap(wx.Rect(330, 0, 30, 22))
        lib['toolPresets'] = tools.GetSubBitmap(wx.Rect(360, 0, 30, 22))
    else:
        tools = images_lib.getToolsBitmap()
        lib['toolOpen'] = tools.GetSubBitmap(wx.Rect(0, 0, 22, 22))
        lib['toolSave'] = tools.GetSubBitmap(wx.Rect(22, 0, 22, 22))
        lib['toolPrint'] = tools.GetSubBitmap(wx.Rect(44, 0, 22, 22))
        
        lib['toolMath'] = tools.GetSubBitmap(wx.Rect(0, 22, 22, 22))
        lib['toolCrop'] = tools.GetSubBitmap(wx.Rect(22, 22, 22, 22))
        lib['toolSmoothing'] = tools.GetSubBitmap(wx.Rect(44, 22, 22, 22))
        lib['toolBaseline'] = tools.GetSubBitmap(wx.Rect(66, 22, 22, 22))
        lib['toolPeakpicking'] = tools.GetSubBitmap(wx.Rect(88, 22, 22, 22))
        lib['toolDeisotoping'] = tools.GetSubBitmap(wx.Rect(110, 22, 22, 22))
        lib['toolCalibration'] = tools.GetSubBitmap(wx.Rect(132, 22, 22, 22))
        lib['toolSequence'] = tools.GetSubBitmap(wx.Rect(0, 44, 22, 22))
        lib['toolDigest'] = tools.GetSubBitmap(wx.Rect(22, 44, 22, 22))
        lib['toolFragment'] = tools.GetSubBitmap(wx.Rect(44, 44, 22, 22))
        lib['toolSearch'] = tools.GetSubBitmap(wx.Rect(66, 44, 22, 22))
        lib['toolMasscalc'] = tools.GetSubBitmap(wx.Rect(0, 66, 22, 22))
        lib['toolCompounds'] = tools.GetSubBitmap(wx.Rect(22, 66, 22, 22))
        lib['toolDifferences'] = tools.GetSubBitmap(wx.Rect(44, 66, 22, 22))
        lib['toolCompare'] = tools.GetSubBitmap(wx.Rect(66, 66, 22, 22))
        lib['toolMascot'] = tools.GetSubBitmap(wx.Rect(88, 66, 22, 22))
        lib['toolProfound'] = tools.GetSubBitmap(wx.Rect(110, 66, 22, 22))
        lib['toolPresets'] = tools.GetSubBitmap(wx.Rect(132, 66, 22, 22))
        lib['toolInfo'] = tools.GetSubBitmap(wx.Rect(0, 88, 22, 22))
        lib['toolReport'] = tools.GetSubBitmap(wx.Rect(22, 88, 22, 22))
        lib['toolExport'] = tools.GetSubBitmap(wx.Rect(44, 88, 22, 22))
    
    # bottombars
    bottombarsOn = images_lib.getBottombarsOnBitmap()
    bottombarsOff = images_lib.getBottombarsOffBitmap()
    
    lib['documentsAdd'] = bottombarsOff.GetSubBitmap(wx.Rect(0, 0, 29, 22))
    lib['documentsDelete'] = bottombarsOff.GetSubBitmap(wx.Rect(29, 0, 29, 22))
    
    lib['peaklistAdd'] = bottombarsOff.GetSubBitmap(wx.Rect(0, 22, 29, 22))
    lib['peaklistDelete'] = bottombarsOff.GetSubBitmap(wx.Rect(29, 22, 29, 22))
    lib['peaklistAnnotate'] = bottombarsOff.GetSubBitmap(wx.Rect(58, 22, 29, 22))
    lib['peaklistEditorOn'] = bottombarsOn.GetSubBitmap(wx.Rect(87, 22, 29, 22))
    lib['peaklistEditorOff'] = bottombarsOff.GetSubBitmap(wx.Rect(87, 22, 29, 22))
    
    lib['spectrumParams'] = bottombarsOff.GetSubBitmap(wx.Rect(0, 44, 29, 22))
    lib['spectrumLabelsOn'] = bottombarsOn.GetSubBitmap(wx.Rect(29, 44, 29, 22))
    lib['spectrumLabelsOff'] = bottombarsOff.GetSubBitmap(wx.Rect(29, 44, 29, 22))
    lib['spectrumTicksOn'] = bottombarsOn.GetSubBitmap(wx.Rect(58, 44, 29, 22))
    lib['spectrumTicksOff'] = bottombarsOff.GetSubBitmap(wx.Rect(58, 44, 29, 22))
    lib['spectrumNotationMarksOn'] = bottombarsOn.GetSubBitmap(wx.Rect(87, 44, 29, 22))
    lib['spectrumNotationMarksOff'] = bottombarsOff.GetSubBitmap(wx.Rect(87, 44, 29, 22))
    lib['spectrumLabelAngleOn'] = bottombarsOn.GetSubBitmap(wx.Rect(116, 44, 29, 22))
    lib['spectrumLabelAngleOff'] = bottombarsOff.GetSubBitmap(wx.Rect(116, 44, 29, 22))
    lib['spectrumPosBarOn'] = bottombarsOn.GetSubBitmap(wx.Rect(145, 44, 29, 22))
    lib['spectrumPosBarOff'] = bottombarsOff.GetSubBitmap(wx.Rect(145, 44, 29, 22))
    lib['spectrumGelOn'] = bottombarsOn.GetSubBitmap(wx.Rect(174, 44, 29, 22))
    lib['spectrumGelOff'] = bottombarsOff.GetSubBitmap(wx.Rect(174, 44, 29, 22))
    lib['spectrumTrackerOn'] = bottombarsOn.GetSubBitmap(wx.Rect(203, 44, 29, 22))
    lib['spectrumTrackerOff'] = bottombarsOff.GetSubBitmap(wx.Rect(203, 44, 29, 22))
    lib['spectrumAutoscaleOn'] = bottombarsOn.GetSubBitmap(wx.Rect(232, 44, 29, 22))
    lib['spectrumAutoscaleOff'] = bottombarsOff.GetSubBitmap(wx.Rect(232, 44, 29, 22))
    lib['spectrumNormalizeOn'] = bottombarsOn.GetSubBitmap(wx.Rect(261, 44, 29, 22))
    lib['spectrumNormalizeOff'] = bottombarsOff.GetSubBitmap(wx.Rect(261, 44, 29, 22))
    
    lib['spectrumLabelPeakOn'] = bottombarsOn.GetSubBitmap(wx.Rect(29, 66, 29, 22))
    lib['spectrumLabelPeakOff'] = bottombarsOff.GetSubBitmap(wx.Rect(29, 66, 29, 22))
    lib['spectrumLabelPointOn'] = bottombarsOn.GetSubBitmap(wx.Rect(58, 66, 29, 22))
    lib['spectrumLabelPointOff'] = bottombarsOff.GetSubBitmap(wx.Rect(58, 66, 29, 22))
    lib['spectrumDeleteLabelOn'] = bottombarsOn.GetSubBitmap(wx.Rect(87, 66, 29, 22))
    lib['spectrumDeleteLabelOff'] = bottombarsOff.GetSubBitmap(wx.Rect(87, 66, 29, 22))
    lib['spectrumMeasureOn'] = bottombarsOn.GetSubBitmap(wx.Rect(116, 66, 29, 22))
    lib['spectrumMeasureOff'] = bottombarsOff.GetSubBitmap(wx.Rect(116, 66, 29, 22))
    lib['spectrumOffsetOn'] = bottombarsOn.GetSubBitmap(wx.Rect(145, 66, 29, 22))
    lib['spectrumOffsetOff'] = bottombarsOff.GetSubBitmap(wx.Rect(145, 66, 29, 22))
    
    # toolbars
    toolbarsOn = images_lib.getToolbarsOnBitmap()
    toolbarsOff = images_lib.getToolbarsOffBitmap()
    
    lib['compoundsCompoundsOn'] = toolbarsOn.GetSubBitmap(wx.Rect(0, 0, 29, 22))
    lib['compoundsCompoundsOff'] = toolbarsOff.GetSubBitmap(wx.Rect(0, 0, 29, 22))
    lib['compoundsFormulaOn'] = toolbarsOn.GetSubBitmap(wx.Rect(29, 0, 29, 22))
    lib['compoundsFormulaOff'] = toolbarsOff.GetSubBitmap(wx.Rect(29, 0, 29, 22))
    
    lib['calibrationReferencesOn'] = toolbarsOn.GetSubBitmap(wx.Rect(0, 22, 29, 22))
    lib['calibrationReferencesOff'] = toolbarsOff.GetSubBitmap(wx.Rect(0, 22, 29, 22))
    lib['calibrationErrorsOn'] = toolbarsOn.GetSubBitmap(wx.Rect(29, 22, 29, 22))
    lib['calibrationErrorsOff'] = toolbarsOff.GetSubBitmap(wx.Rect(29, 22, 29, 22))
    
    lib['exportImageOn'] = toolbarsOn.GetSubBitmap(wx.Rect(0, 44, 29, 22))
    lib['exportImageOff'] = toolbarsOff.GetSubBitmap(wx.Rect(0, 44, 29, 22))
    lib['exportPeaklistOn'] = toolbarsOn.GetSubBitmap(wx.Rect(29, 44, 29, 22))
    lib['exportPeaklistOff'] = toolbarsOff.GetSubBitmap(wx.Rect(29, 44, 29, 22))
    lib['exportSpectrumOn'] = toolbarsOn.GetSubBitmap(wx.Rect(58, 44, 29, 22))
    lib['exportSpectrumOff'] = toolbarsOff.GetSubBitmap(wx.Rect(58, 44, 29, 22))
    
    lib['infoSummaryOn'] = toolbarsOn.GetSubBitmap(wx.Rect(0, 66, 29, 22))
    lib['infoSummaryOff'] = toolbarsOff.GetSubBitmap(wx.Rect(0, 66, 29, 22))
    lib['infoSpectrumOn'] = toolbarsOn.GetSubBitmap(wx.Rect(29, 66, 29, 22))
    lib['infoSpectrumOff'] = toolbarsOff.GetSubBitmap(wx.Rect(29, 66, 29, 22))
    lib['infoNotesOn'] = toolbarsOn.GetSubBitmap(wx.Rect(58, 66, 29, 22))
    lib['infoNotesOff'] = toolbarsOff.GetSubBitmap(wx.Rect(58, 66, 29, 22))
    
    lib['mascotPMFOn'] = toolbarsOn.GetSubBitmap(wx.Rect(0, 88, 29, 22))
    lib['mascotPMFOff'] = toolbarsOff.GetSubBitmap(wx.Rect(0, 88, 29, 22))
    lib['mascotMISOn'] = toolbarsOn.GetSubBitmap(wx.Rect(29, 88, 29, 22))
    lib['mascotMISOff'] = toolbarsOff.GetSubBitmap(wx.Rect(29, 88, 29, 22))
    lib['mascotSQOn'] = toolbarsOn.GetSubBitmap(wx.Rect(58, 88, 29, 22))
    lib['mascotSQOff'] = toolbarsOff.GetSubBitmap(wx.Rect(58, 88, 29, 22))
    lib['mascotQueryOn'] = toolbarsOn.GetSubBitmap(wx.Rect(87, 88, 29, 22))
    lib['mascotQueryOff'] = toolbarsOff.GetSubBitmap(wx.Rect(87, 88, 29, 22))
    
    lib['masscalcSummaryOn'] = toolbarsOn.GetSubBitmap(wx.Rect(0, 110, 29, 22))
    lib['masscalcSummaryOff'] = toolbarsOff.GetSubBitmap(wx.Rect(0, 110, 29, 22))
    lib['masscalcIonSeriesOn'] = toolbarsOn.GetSubBitmap(wx.Rect(29, 110, 29, 22))
    lib['masscalcIonSeriesOff'] = toolbarsOff.GetSubBitmap(wx.Rect(29, 110, 29, 22))
    lib['masscalcPatternOn'] = toolbarsOn.GetSubBitmap(wx.Rect(58, 110, 29, 22))
    lib['masscalcPatternOff'] = toolbarsOff.GetSubBitmap(wx.Rect(58, 110, 29, 22))
    
    lib['processingMathOn'] = toolbarsOn.GetSubBitmap(wx.Rect(0, 132, 29, 22))
    lib['processingMathOff'] = toolbarsOff.GetSubBitmap(wx.Rect(0, 132, 29, 22))
    lib['processingCropOn'] = toolbarsOn.GetSubBitmap(wx.Rect(29, 132, 29, 22))
    lib['processingCropOff'] = toolbarsOff.GetSubBitmap(wx.Rect(29, 132, 29, 22))
    lib['processingBaselineOn'] = toolbarsOn.GetSubBitmap(wx.Rect(58, 132, 29, 22))
    lib['processingBaselineOff'] = toolbarsOff.GetSubBitmap(wx.Rect(58, 132, 29, 22))
    lib['processingSmoothingOn'] = toolbarsOn.GetSubBitmap(wx.Rect(87, 132, 29, 22))
    lib['processingSmoothingOff'] = toolbarsOff.GetSubBitmap(wx.Rect(87, 132, 29, 22))
    lib['processingPeakpickingOn'] = toolbarsOn.GetSubBitmap(wx.Rect(116, 132, 29, 22))
    lib['processingPeakpickingOff'] = toolbarsOff.GetSubBitmap(wx.Rect(116, 132, 29, 22))
    lib['processingDeisotopingOn'] = toolbarsOn.GetSubBitmap(wx.Rect(145, 132, 29, 22))
    lib['processingDeisotopingOff'] = toolbarsOff.GetSubBitmap(wx.Rect(145, 132, 29, 22))
    
    lib['sequenceEditorOn'] = toolbarsOn.GetSubBitmap(wx.Rect(0, 154, 29, 22))
    lib['sequenceEditorOff'] = toolbarsOff.GetSubBitmap(wx.Rect(0, 154, 29, 22))
    lib['sequenceModificationsOn'] = toolbarsOn.GetSubBitmap(wx.Rect(29, 154, 29, 22))
    lib['sequenceModificationsOff'] = toolbarsOff.GetSubBitmap(wx.Rect(29, 154, 29, 22))
    lib['sequenceDigestOn'] = toolbarsOn.GetSubBitmap(wx.Rect(58, 154, 29, 22))
    lib['sequenceDigestOff'] = toolbarsOff.GetSubBitmap(wx.Rect(58, 154, 29, 22))
    lib['sequenceFragmentOn'] = toolbarsOn.GetSubBitmap(wx.Rect(87, 154, 29, 22))
    lib['sequenceFragmentOff'] = toolbarsOff.GetSubBitmap(wx.Rect(87, 154, 29, 22))
    lib['sequenceSearchOn'] = toolbarsOn.GetSubBitmap(wx.Rect(116, 154, 29, 22))
    lib['sequenceSearchOff'] = toolbarsOff.GetSubBitmap(wx.Rect(116, 154, 29, 22))
    
    lib['profoundPMFOn'] = toolbarsOn.GetSubBitmap(wx.Rect(0, 176, 29, 22))
    lib['profoundPMFOff'] = toolbarsOff.GetSubBitmap(wx.Rect(0, 176, 29, 22))
    lib['profoundQueryOn'] = toolbarsOn.GetSubBitmap(wx.Rect(58, 176, 29, 22))
    lib['profoundQueryOff'] = toolbarsOff.GetSubBitmap(wx.Rect(58, 176, 29, 22))
    
    lib['prospectorMSFitOn'] = toolbarsOn.GetSubBitmap(wx.Rect(0, 176, 29, 22))
    lib['prospectorMSFitOff'] = toolbarsOff.GetSubBitmap(wx.Rect(0, 176, 29, 22))
    lib['prospectorMSTagOn'] = toolbarsOn.GetSubBitmap(wx.Rect(29, 88, 29, 22))
    lib['prospectorMSTagOff'] = toolbarsOff.GetSubBitmap(wx.Rect(29, 88, 29, 22))
    lib['prospectorQueryOn'] = toolbarsOn.GetSubBitmap(wx.Rect(58, 176, 29, 22))
    lib['prospectorQueryOff'] = toolbarsOff.GetSubBitmap(wx.Rect(58, 176, 29, 22))
    
    lib['matchErrorsOn'] = toolbarsOn.GetSubBitmap(wx.Rect(0, 198, 29, 22))
    lib['matchErrorsOff'] = toolbarsOff.GetSubBitmap(wx.Rect(0, 198, 29, 22))
    lib['matchSummaryOn'] = toolbarsOn.GetSubBitmap(wx.Rect(29, 198, 29, 22))
    lib['matchSummaryOff'] = toolbarsOff.GetSubBitmap(wx.Rect(29, 198, 29, 22))
    
    # periodic table
    ptableOn = images_lib.getPtableOnBitmap()
    ptableOff = images_lib.getPtableOffBitmap()
    ptableSel = images_lib.getPtableSelBitmap()
    
    lib['connection'] = ptableOn.GetSubBitmap(wx.Rect(48, 183, 24, 72))
    
    lib['ptableHOn'] = ptableOn.GetSubBitmap(wx.Rect(0, 0, 25, 27))
    lib['ptableHeOn'] = ptableOn.GetSubBitmap(wx.Rect(408, 0, 25, 27))
    lib['ptableLiOn'] = ptableOn.GetSubBitmap(wx.Rect(0, 26, 25, 27))
    lib['ptableBeOn'] = ptableOn.GetSubBitmap(wx.Rect(24, 26, 25, 27))
    lib['ptableBOn'] = ptableOn.GetSubBitmap(wx.Rect(288, 26, 25, 27))
    lib['ptableCOn'] = ptableOn.GetSubBitmap(wx.Rect(312, 26, 25, 27))
    lib['ptableNOn'] = ptableOn.GetSubBitmap(wx.Rect(336, 26, 25, 27))
    lib['ptableOOn'] = ptableOn.GetSubBitmap(wx.Rect(360, 26, 25, 27))
    lib['ptableFOn'] = ptableOn.GetSubBitmap(wx.Rect(384, 26, 25, 27))
    lib['ptableNeOn'] = ptableOn.GetSubBitmap(wx.Rect(408, 26, 25, 27))
    lib['ptableNaOn'] = ptableOn.GetSubBitmap(wx.Rect(0, 52, 25, 27))
    lib['ptableMgOn'] = ptableOn.GetSubBitmap(wx.Rect(24, 52, 25, 27))
    lib['ptableAlOn'] = ptableOn.GetSubBitmap(wx.Rect(288, 52, 25, 27))
    lib['ptableSiOn'] = ptableOn.GetSubBitmap(wx.Rect(312, 52, 25, 27))
    lib['ptablePOn'] = ptableOn.GetSubBitmap(wx.Rect(336, 52, 25, 27))
    lib['ptableSOn'] = ptableOn.GetSubBitmap(wx.Rect(360, 52, 25, 27))
    lib['ptableClOn'] = ptableOn.GetSubBitmap(wx.Rect(384, 52, 25, 27))
    lib['ptableArOn'] = ptableOn.GetSubBitmap(wx.Rect(408, 52, 25, 27))
    lib['ptableKOn'] = ptableOn.GetSubBitmap(wx.Rect(0, 78, 25, 27))
    lib['ptableCaOn'] = ptableOn.GetSubBitmap(wx.Rect(24, 78, 25, 27))
    lib['ptableScOn'] = ptableOn.GetSubBitmap(wx.Rect(48, 78, 25, 27))
    lib['ptableTiOn'] = ptableOn.GetSubBitmap(wx.Rect(72, 78, 25, 27))
    lib['ptableVOn'] = ptableOn.GetSubBitmap(wx.Rect(96, 78, 25, 27))
    lib['ptableCrOn'] = ptableOn.GetSubBitmap(wx.Rect(120, 78, 25, 27))
    lib['ptableMnOn'] = ptableOn.GetSubBitmap(wx.Rect(144, 78, 25, 27))
    lib['ptableFeOn'] = ptableOn.GetSubBitmap(wx.Rect(168, 78, 25, 27))
    lib['ptableCoOn'] = ptableOn.GetSubBitmap(wx.Rect(192, 78, 25, 27))
    lib['ptableNiOn'] = ptableOn.GetSubBitmap(wx.Rect(216, 78, 25, 27))
    lib['ptableCuOn'] = ptableOn.GetSubBitmap(wx.Rect(240, 78, 25, 27))
    lib['ptableZnOn'] = ptableOn.GetSubBitmap(wx.Rect(264, 78, 25, 27))
    lib['ptableGaOn'] = ptableOn.GetSubBitmap(wx.Rect(288, 78, 25, 27))
    lib['ptableGeOn'] = ptableOn.GetSubBitmap(wx.Rect(312, 78, 25, 27))
    lib['ptableAsOn'] = ptableOn.GetSubBitmap(wx.Rect(336, 78, 25, 27))
    lib['ptableSeOn'] = ptableOn.GetSubBitmap(wx.Rect(360, 78, 25, 27))
    lib['ptableBrOn'] = ptableOn.GetSubBitmap(wx.Rect(384, 78, 25, 27))
    lib['ptableKrOn'] = ptableOn.GetSubBitmap(wx.Rect(408, 78, 25, 27))
    lib['ptableRbOn'] = ptableOn.GetSubBitmap(wx.Rect(0, 104, 25, 27))
    lib['ptableSrOn'] = ptableOn.GetSubBitmap(wx.Rect(24, 104, 25, 27))
    lib['ptableYOn'] = ptableOn.GetSubBitmap(wx.Rect(48, 104, 25, 27))
    lib['ptableZrOn'] = ptableOn.GetSubBitmap(wx.Rect(72, 104, 25, 27))
    lib['ptableNbOn'] = ptableOn.GetSubBitmap(wx.Rect(96, 104, 25, 27))
    lib['ptableMoOn'] = ptableOn.GetSubBitmap(wx.Rect(120, 104, 25, 27))
    lib['ptableTcOn'] = ptableOn.GetSubBitmap(wx.Rect(144, 104, 25, 27))
    lib['ptableRuOn'] = ptableOn.GetSubBitmap(wx.Rect(168, 104, 25, 27))
    lib['ptableRhOn'] = ptableOn.GetSubBitmap(wx.Rect(192, 104, 25, 27))
    lib['ptablePdOn'] = ptableOn.GetSubBitmap(wx.Rect(216, 104, 25, 27))
    lib['ptableAgOn'] = ptableOn.GetSubBitmap(wx.Rect(240, 104, 25, 27))
    lib['ptableCdOn'] = ptableOn.GetSubBitmap(wx.Rect(264, 104, 25, 27))
    lib['ptableInOn'] = ptableOn.GetSubBitmap(wx.Rect(288, 104, 25, 27))
    lib['ptableSnOn'] = ptableOn.GetSubBitmap(wx.Rect(312, 104, 25, 27))
    lib['ptableSbOn'] = ptableOn.GetSubBitmap(wx.Rect(336, 104, 25, 27))
    lib['ptableTeOn'] = ptableOn.GetSubBitmap(wx.Rect(360, 104, 25, 27))
    lib['ptableIOn'] = ptableOn.GetSubBitmap(wx.Rect(384, 104, 25, 27))
    lib['ptableXeOn'] = ptableOn.GetSubBitmap(wx.Rect(408, 104, 25, 27))
    lib['ptableCsOn'] = ptableOn.GetSubBitmap(wx.Rect(0, 130, 25, 27))
    lib['ptableBaOn'] = ptableOn.GetSubBitmap(wx.Rect(24, 130, 25, 27))
    lib['ptableLaOn'] = ptableOn.GetSubBitmap(wx.Rect(48, 130, 25, 27))
    lib['ptableHfOn'] = ptableOn.GetSubBitmap(wx.Rect(72, 130, 25, 27))
    lib['ptableTaOn'] = ptableOn.GetSubBitmap(wx.Rect(96, 130, 25, 27))
    lib['ptableWOn'] = ptableOn.GetSubBitmap(wx.Rect(120, 130, 25, 27))
    lib['ptableReOn'] = ptableOn.GetSubBitmap(wx.Rect(144, 130, 25, 27))
    lib['ptableOsOn'] = ptableOn.GetSubBitmap(wx.Rect(168, 130, 25, 27))
    lib['ptableIrOn'] = ptableOn.GetSubBitmap(wx.Rect(192, 130, 25, 27))
    lib['ptablePtOn'] = ptableOn.GetSubBitmap(wx.Rect(216, 130, 25, 27))
    lib['ptableAuOn'] = ptableOn.GetSubBitmap(wx.Rect(240, 130, 25, 27))
    lib['ptableHgOn'] = ptableOn.GetSubBitmap(wx.Rect(264, 130, 25, 27))
    lib['ptableTlOn'] = ptableOn.GetSubBitmap(wx.Rect(288, 130, 25, 27))
    lib['ptablePbOn'] = ptableOn.GetSubBitmap(wx.Rect(312, 130, 25, 27))
    lib['ptableBiOn'] = ptableOn.GetSubBitmap(wx.Rect(336, 130, 25, 27))
    lib['ptablePoOn'] = ptableOn.GetSubBitmap(wx.Rect(360, 130, 25, 27))
    lib['ptableAtOn'] = ptableOn.GetSubBitmap(wx.Rect(384, 130, 25, 27))
    lib['ptableRnOn'] = ptableOn.GetSubBitmap(wx.Rect(408, 130, 25, 27))
    lib['ptableFrOn'] = ptableOn.GetSubBitmap(wx.Rect(0, 156, 25, 27))
    lib['ptableRaOn'] = ptableOn.GetSubBitmap(wx.Rect(24, 156, 25, 27))
    lib['ptableAcOn'] = ptableOn.GetSubBitmap(wx.Rect(48, 156, 25, 27))
    lib['ptableCeOn'] = ptableOn.GetSubBitmap(wx.Rect(72, 202, 25, 27))
    lib['ptablePrOn'] = ptableOn.GetSubBitmap(wx.Rect(96, 202, 25, 27))
    lib['ptableNdOn'] = ptableOn.GetSubBitmap(wx.Rect(120, 202, 25, 27))
    lib['ptablePmOn'] = ptableOn.GetSubBitmap(wx.Rect(144, 202, 25, 27))
    lib['ptableSmOn'] = ptableOn.GetSubBitmap(wx.Rect(168, 202, 25, 27))
    lib['ptableEuOn'] = ptableOn.GetSubBitmap(wx.Rect(192, 202, 25, 27))
    lib['ptableGdOn'] = ptableOn.GetSubBitmap(wx.Rect(216, 202, 25, 27))
    lib['ptableTbOn'] = ptableOn.GetSubBitmap(wx.Rect(240, 202, 25, 27))
    lib['ptableDyOn'] = ptableOn.GetSubBitmap(wx.Rect(264, 202, 25, 27))
    lib['ptableHoOn'] = ptableOn.GetSubBitmap(wx.Rect(288, 202, 25, 27))
    lib['ptableErOn'] = ptableOn.GetSubBitmap(wx.Rect(312, 202, 25, 27))
    lib['ptableTmOn'] = ptableOn.GetSubBitmap(wx.Rect(336, 202, 25, 27))
    lib['ptableYbOn'] = ptableOn.GetSubBitmap(wx.Rect(360, 202, 25, 27))
    lib['ptableLuOn'] = ptableOn.GetSubBitmap(wx.Rect(384, 202, 25, 27))
    lib['ptableThOn'] = ptableOn.GetSubBitmap(wx.Rect(72, 228, 25, 27))
    lib['ptablePaOn'] = ptableOn.GetSubBitmap(wx.Rect(96, 228, 25, 27))
    lib['ptableUOn'] = ptableOn.GetSubBitmap(wx.Rect(120, 228, 25, 27))
    lib['ptableNpOn'] = ptableOn.GetSubBitmap(wx.Rect(144, 228, 25, 27))
    lib['ptablePuOn'] = ptableOn.GetSubBitmap(wx.Rect(168, 228, 25, 27))
    lib['ptableAmOn'] = ptableOn.GetSubBitmap(wx.Rect(192, 228, 25, 27))
    lib['ptableCmOn'] = ptableOn.GetSubBitmap(wx.Rect(216, 228, 25, 27))
    lib['ptableBkOn'] = ptableOn.GetSubBitmap(wx.Rect(240, 228, 25, 27))
    lib['ptableCfOn'] = ptableOn.GetSubBitmap(wx.Rect(264, 228, 25, 27))
    lib['ptableEsOn'] = ptableOn.GetSubBitmap(wx.Rect(288, 228, 25, 27))
    lib['ptableFmOn'] = ptableOn.GetSubBitmap(wx.Rect(312, 228, 25, 27))
    lib['ptableMdOn'] = ptableOn.GetSubBitmap(wx.Rect(336, 228, 25, 27))
    lib['ptableNoOn'] = ptableOn.GetSubBitmap(wx.Rect(360, 228, 25, 27))
    lib['ptableLrOn'] = ptableOn.GetSubBitmap(wx.Rect(384, 228, 25, 27))
    
    lib['ptableHOff'] = ptableOff.GetSubBitmap(wx.Rect(0, 0, 25, 27))
    lib['ptableHeOff'] = ptableOff.GetSubBitmap(wx.Rect(408, 0, 25, 27))
    lib['ptableLiOff'] = ptableOff.GetSubBitmap(wx.Rect(0, 26, 25, 27))
    lib['ptableBeOff'] = ptableOff.GetSubBitmap(wx.Rect(24, 26, 25, 27))
    lib['ptableBOff'] = ptableOff.GetSubBitmap(wx.Rect(288, 26, 25, 27))
    lib['ptableCOff'] = ptableOff.GetSubBitmap(wx.Rect(312, 26, 25, 27))
    lib['ptableNOff'] = ptableOff.GetSubBitmap(wx.Rect(336, 26, 25, 27))
    lib['ptableOOff'] = ptableOff.GetSubBitmap(wx.Rect(360, 26, 25, 27))
    lib['ptableFOff'] = ptableOff.GetSubBitmap(wx.Rect(384, 26, 25, 27))
    lib['ptableNeOff'] = ptableOff.GetSubBitmap(wx.Rect(408, 26, 25, 27))
    lib['ptableNaOff'] = ptableOff.GetSubBitmap(wx.Rect(0, 52, 25, 27))
    lib['ptableMgOff'] = ptableOff.GetSubBitmap(wx.Rect(24, 52, 25, 27))
    lib['ptableAlOff'] = ptableOff.GetSubBitmap(wx.Rect(288, 52, 25, 27))
    lib['ptableSiOff'] = ptableOff.GetSubBitmap(wx.Rect(312, 52, 25, 27))
    lib['ptablePOff'] = ptableOff.GetSubBitmap(wx.Rect(336, 52, 25, 27))
    lib['ptableSOff'] = ptableOff.GetSubBitmap(wx.Rect(360, 52, 25, 27))
    lib['ptableClOff'] = ptableOff.GetSubBitmap(wx.Rect(384, 52, 25, 27))
    lib['ptableArOff'] = ptableOff.GetSubBitmap(wx.Rect(408, 52, 25, 27))
    lib['ptableKOff'] = ptableOff.GetSubBitmap(wx.Rect(0, 78, 25, 27))
    lib['ptableCaOff'] = ptableOff.GetSubBitmap(wx.Rect(24, 78, 25, 27))
    lib['ptableScOff'] = ptableOff.GetSubBitmap(wx.Rect(48, 78, 25, 27))
    lib['ptableTiOff'] = ptableOff.GetSubBitmap(wx.Rect(72, 78, 25, 27))
    lib['ptableVOff'] = ptableOff.GetSubBitmap(wx.Rect(96, 78, 25, 27))
    lib['ptableCrOff'] = ptableOff.GetSubBitmap(wx.Rect(120, 78, 25, 27))
    lib['ptableMnOff'] = ptableOff.GetSubBitmap(wx.Rect(144, 78, 25, 27))
    lib['ptableFeOff'] = ptableOff.GetSubBitmap(wx.Rect(168, 78, 25, 27))
    lib['ptableCoOff'] = ptableOff.GetSubBitmap(wx.Rect(192, 78, 25, 27))
    lib['ptableNiOff'] = ptableOff.GetSubBitmap(wx.Rect(216, 78, 25, 27))
    lib['ptableCuOff'] = ptableOff.GetSubBitmap(wx.Rect(240, 78, 25, 27))
    lib['ptableZnOff'] = ptableOff.GetSubBitmap(wx.Rect(264, 78, 25, 27))
    lib['ptableGaOff'] = ptableOff.GetSubBitmap(wx.Rect(288, 78, 25, 27))
    lib['ptableGeOff'] = ptableOff.GetSubBitmap(wx.Rect(312, 78, 25, 27))
    lib['ptableAsOff'] = ptableOff.GetSubBitmap(wx.Rect(336, 78, 25, 27))
    lib['ptableSeOff'] = ptableOff.GetSubBitmap(wx.Rect(360, 78, 25, 27))
    lib['ptableBrOff'] = ptableOff.GetSubBitmap(wx.Rect(384, 78, 25, 27))
    lib['ptableKrOff'] = ptableOff.GetSubBitmap(wx.Rect(408, 78, 25, 27))
    lib['ptableRbOff'] = ptableOff.GetSubBitmap(wx.Rect(0, 104, 25, 27))
    lib['ptableSrOff'] = ptableOff.GetSubBitmap(wx.Rect(24, 104, 25, 27))
    lib['ptableYOff'] = ptableOff.GetSubBitmap(wx.Rect(48, 104, 25, 27))
    lib['ptableZrOff'] = ptableOff.GetSubBitmap(wx.Rect(72, 104, 25, 27))
    lib['ptableNbOff'] = ptableOff.GetSubBitmap(wx.Rect(96, 104, 25, 27))
    lib['ptableMoOff'] = ptableOff.GetSubBitmap(wx.Rect(120, 104, 25, 27))
    lib['ptableTcOff'] = ptableOff.GetSubBitmap(wx.Rect(144, 104, 25, 27))
    lib['ptableRuOff'] = ptableOff.GetSubBitmap(wx.Rect(168, 104, 25, 27))
    lib['ptableRhOff'] = ptableOff.GetSubBitmap(wx.Rect(192, 104, 25, 27))
    lib['ptablePdOff'] = ptableOff.GetSubBitmap(wx.Rect(216, 104, 25, 27))
    lib['ptableAgOff'] = ptableOff.GetSubBitmap(wx.Rect(240, 104, 25, 27))
    lib['ptableCdOff'] = ptableOff.GetSubBitmap(wx.Rect(264, 104, 25, 27))
    lib['ptableInOff'] = ptableOff.GetSubBitmap(wx.Rect(288, 104, 25, 27))
    lib['ptableSnOff'] = ptableOff.GetSubBitmap(wx.Rect(312, 104, 25, 27))
    lib['ptableSbOff'] = ptableOff.GetSubBitmap(wx.Rect(336, 104, 25, 27))
    lib['ptableTeOff'] = ptableOff.GetSubBitmap(wx.Rect(360, 104, 25, 27))
    lib['ptableIOff'] = ptableOff.GetSubBitmap(wx.Rect(384, 104, 25, 27))
    lib['ptableXeOff'] = ptableOff.GetSubBitmap(wx.Rect(408, 104, 25, 27))
    lib['ptableCsOff'] = ptableOff.GetSubBitmap(wx.Rect(0, 130, 25, 27))
    lib['ptableBaOff'] = ptableOff.GetSubBitmap(wx.Rect(24, 130, 25, 27))
    lib['ptableLaOff'] = ptableOff.GetSubBitmap(wx.Rect(48, 130, 25, 27))
    lib['ptableHfOff'] = ptableOff.GetSubBitmap(wx.Rect(72, 130, 25, 27))
    lib['ptableTaOff'] = ptableOff.GetSubBitmap(wx.Rect(96, 130, 25, 27))
    lib['ptableWOff'] = ptableOff.GetSubBitmap(wx.Rect(120, 130, 25, 27))
    lib['ptableReOff'] = ptableOff.GetSubBitmap(wx.Rect(144, 130, 25, 27))
    lib['ptableOsOff'] = ptableOff.GetSubBitmap(wx.Rect(168, 130, 25, 27))
    lib['ptableIrOff'] = ptableOff.GetSubBitmap(wx.Rect(192, 130, 25, 27))
    lib['ptablePtOff'] = ptableOff.GetSubBitmap(wx.Rect(216, 130, 25, 27))
    lib['ptableAuOff'] = ptableOff.GetSubBitmap(wx.Rect(240, 130, 25, 27))
    lib['ptableHgOff'] = ptableOff.GetSubBitmap(wx.Rect(264, 130, 25, 27))
    lib['ptableTlOff'] = ptableOff.GetSubBitmap(wx.Rect(288, 130, 25, 27))
    lib['ptablePbOff'] = ptableOff.GetSubBitmap(wx.Rect(312, 130, 25, 27))
    lib['ptableBiOff'] = ptableOff.GetSubBitmap(wx.Rect(336, 130, 25, 27))
    lib['ptablePoOff'] = ptableOff.GetSubBitmap(wx.Rect(360, 130, 25, 27))
    lib['ptableAtOff'] = ptableOff.GetSubBitmap(wx.Rect(384, 130, 25, 27))
    lib['ptableRnOff'] = ptableOff.GetSubBitmap(wx.Rect(408, 130, 25, 27))
    lib['ptableFrOff'] = ptableOff.GetSubBitmap(wx.Rect(0, 156, 25, 27))
    lib['ptableRaOff'] = ptableOff.GetSubBitmap(wx.Rect(24, 156, 25, 27))
    lib['ptableAcOff'] = ptableOff.GetSubBitmap(wx.Rect(48, 156, 25, 27))
    lib['ptableCeOff'] = ptableOff.GetSubBitmap(wx.Rect(72, 202, 25, 27))
    lib['ptablePrOff'] = ptableOff.GetSubBitmap(wx.Rect(96, 202, 25, 27))
    lib['ptableNdOff'] = ptableOff.GetSubBitmap(wx.Rect(120, 202, 25, 27))
    lib['ptablePmOff'] = ptableOff.GetSubBitmap(wx.Rect(144, 202, 25, 27))
    lib['ptableSmOff'] = ptableOff.GetSubBitmap(wx.Rect(168, 202, 25, 27))
    lib['ptableEuOff'] = ptableOff.GetSubBitmap(wx.Rect(192, 202, 25, 27))
    lib['ptableGdOff'] = ptableOff.GetSubBitmap(wx.Rect(216, 202, 25, 27))
    lib['ptableTbOff'] = ptableOff.GetSubBitmap(wx.Rect(240, 202, 25, 27))
    lib['ptableDyOff'] = ptableOff.GetSubBitmap(wx.Rect(264, 202, 25, 27))
    lib['ptableHoOff'] = ptableOff.GetSubBitmap(wx.Rect(288, 202, 25, 27))
    lib['ptableErOff'] = ptableOff.GetSubBitmap(wx.Rect(312, 202, 25, 27))
    lib['ptableTmOff'] = ptableOff.GetSubBitmap(wx.Rect(336, 202, 25, 27))
    lib['ptableYbOff'] = ptableOff.GetSubBitmap(wx.Rect(360, 202, 25, 27))
    lib['ptableLuOff'] = ptableOff.GetSubBitmap(wx.Rect(384, 202, 25, 27))
    lib['ptableThOff'] = ptableOff.GetSubBitmap(wx.Rect(72, 228, 25, 27))
    lib['ptablePaOff'] = ptableOff.GetSubBitmap(wx.Rect(96, 228, 25, 27))
    lib['ptableUOff'] = ptableOff.GetSubBitmap(wx.Rect(120, 228, 25, 27))
    lib['ptableNpOff'] = ptableOff.GetSubBitmap(wx.Rect(144, 228, 25, 27))
    lib['ptablePuOff'] = ptableOff.GetSubBitmap(wx.Rect(168, 228, 25, 27))
    lib['ptableAmOff'] = ptableOff.GetSubBitmap(wx.Rect(192, 228, 25, 27))
    lib['ptableCmOff'] = ptableOff.GetSubBitmap(wx.Rect(216, 228, 25, 27))
    lib['ptableBkOff'] = ptableOff.GetSubBitmap(wx.Rect(240, 228, 25, 27))
    lib['ptableCfOff'] = ptableOff.GetSubBitmap(wx.Rect(264, 228, 25, 27))
    lib['ptableEsOff'] = ptableOff.GetSubBitmap(wx.Rect(288, 228, 25, 27))
    lib['ptableFmOff'] = ptableOff.GetSubBitmap(wx.Rect(312, 228, 25, 27))
    lib['ptableMdOff'] = ptableOff.GetSubBitmap(wx.Rect(336, 228, 25, 27))
    lib['ptableNoOff'] = ptableOff.GetSubBitmap(wx.Rect(360, 228, 25, 27))
    lib['ptableLrOff'] = ptableOff.GetSubBitmap(wx.Rect(384, 228, 25, 27))
    
    lib['ptableHSel'] = ptableSel.GetSubBitmap(wx.Rect(0, 0, 25, 27))
    lib['ptableHeSel'] = ptableSel.GetSubBitmap(wx.Rect(408, 0, 25, 27))
    lib['ptableLiSel'] = ptableSel.GetSubBitmap(wx.Rect(0, 26, 25, 27))
    lib['ptableBeSel'] = ptableSel.GetSubBitmap(wx.Rect(24, 26, 25, 27))
    lib['ptableBSel'] = ptableSel.GetSubBitmap(wx.Rect(288, 26, 25, 27))
    lib['ptableCSel'] = ptableSel.GetSubBitmap(wx.Rect(312, 26, 25, 27))
    lib['ptableNSel'] = ptableSel.GetSubBitmap(wx.Rect(336, 26, 25, 27))
    lib['ptableOSel'] = ptableSel.GetSubBitmap(wx.Rect(360, 26, 25, 27))
    lib['ptableFSel'] = ptableSel.GetSubBitmap(wx.Rect(384, 26, 25, 27))
    lib['ptableNeSel'] = ptableSel.GetSubBitmap(wx.Rect(408, 26, 25, 27))
    lib['ptableNaSel'] = ptableSel.GetSubBitmap(wx.Rect(0, 52, 25, 27))
    lib['ptableMgSel'] = ptableSel.GetSubBitmap(wx.Rect(24, 52, 25, 27))
    lib['ptableAlSel'] = ptableSel.GetSubBitmap(wx.Rect(288, 52, 25, 27))
    lib['ptableSiSel'] = ptableSel.GetSubBitmap(wx.Rect(312, 52, 25, 27))
    lib['ptablePSel'] = ptableSel.GetSubBitmap(wx.Rect(336, 52, 25, 27))
    lib['ptableSSel'] = ptableSel.GetSubBitmap(wx.Rect(360, 52, 25, 27))
    lib['ptableClSel'] = ptableSel.GetSubBitmap(wx.Rect(384, 52, 25, 27))
    lib['ptableArSel'] = ptableSel.GetSubBitmap(wx.Rect(408, 52, 25, 27))
    lib['ptableKSel'] = ptableSel.GetSubBitmap(wx.Rect(0, 78, 25, 27))
    lib['ptableCaSel'] = ptableSel.GetSubBitmap(wx.Rect(24, 78, 25, 27))
    lib['ptableScSel'] = ptableSel.GetSubBitmap(wx.Rect(48, 78, 25, 27))
    lib['ptableTiSel'] = ptableSel.GetSubBitmap(wx.Rect(72, 78, 25, 27))
    lib['ptableVSel'] = ptableSel.GetSubBitmap(wx.Rect(96, 78, 25, 27))
    lib['ptableCrSel'] = ptableSel.GetSubBitmap(wx.Rect(120, 78, 25, 27))
    lib['ptableMnSel'] = ptableSel.GetSubBitmap(wx.Rect(144, 78, 25, 27))
    lib['ptableFeSel'] = ptableSel.GetSubBitmap(wx.Rect(168, 78, 25, 27))
    lib['ptableCoSel'] = ptableSel.GetSubBitmap(wx.Rect(192, 78, 25, 27))
    lib['ptableNiSel'] = ptableSel.GetSubBitmap(wx.Rect(216, 78, 25, 27))
    lib['ptableCuSel'] = ptableSel.GetSubBitmap(wx.Rect(240, 78, 25, 27))
    lib['ptableZnSel'] = ptableSel.GetSubBitmap(wx.Rect(264, 78, 25, 27))
    lib['ptableGaSel'] = ptableSel.GetSubBitmap(wx.Rect(288, 78, 25, 27))
    lib['ptableGeSel'] = ptableSel.GetSubBitmap(wx.Rect(312, 78, 25, 27))
    lib['ptableAsSel'] = ptableSel.GetSubBitmap(wx.Rect(336, 78, 25, 27))
    lib['ptableSeSel'] = ptableSel.GetSubBitmap(wx.Rect(360, 78, 25, 27))
    lib['ptableBrSel'] = ptableSel.GetSubBitmap(wx.Rect(384, 78, 25, 27))
    lib['ptableKrSel'] = ptableSel.GetSubBitmap(wx.Rect(408, 78, 25, 27))
    lib['ptableRbSel'] = ptableSel.GetSubBitmap(wx.Rect(0, 104, 25, 27))
    lib['ptableSrSel'] = ptableSel.GetSubBitmap(wx.Rect(24, 104, 25, 27))
    lib['ptableYSel'] = ptableSel.GetSubBitmap(wx.Rect(48, 104, 25, 27))
    lib['ptableZrSel'] = ptableSel.GetSubBitmap(wx.Rect(72, 104, 25, 27))
    lib['ptableNbSel'] = ptableSel.GetSubBitmap(wx.Rect(96, 104, 25, 27))
    lib['ptableMoSel'] = ptableSel.GetSubBitmap(wx.Rect(120, 104, 25, 27))
    lib['ptableTcSel'] = ptableSel.GetSubBitmap(wx.Rect(144, 104, 25, 27))
    lib['ptableRuSel'] = ptableSel.GetSubBitmap(wx.Rect(168, 104, 25, 27))
    lib['ptableRhSel'] = ptableSel.GetSubBitmap(wx.Rect(192, 104, 25, 27))
    lib['ptablePdSel'] = ptableSel.GetSubBitmap(wx.Rect(216, 104, 25, 27))
    lib['ptableAgSel'] = ptableSel.GetSubBitmap(wx.Rect(240, 104, 25, 27))
    lib['ptableCdSel'] = ptableSel.GetSubBitmap(wx.Rect(264, 104, 25, 27))
    lib['ptableInSel'] = ptableSel.GetSubBitmap(wx.Rect(288, 104, 25, 27))
    lib['ptableSnSel'] = ptableSel.GetSubBitmap(wx.Rect(312, 104, 25, 27))
    lib['ptableSbSel'] = ptableSel.GetSubBitmap(wx.Rect(336, 104, 25, 27))
    lib['ptableTeSel'] = ptableSel.GetSubBitmap(wx.Rect(360, 104, 25, 27))
    lib['ptableISel'] = ptableSel.GetSubBitmap(wx.Rect(384, 104, 25, 27))
    lib['ptableXeSel'] = ptableSel.GetSubBitmap(wx.Rect(408, 104, 25, 27))
    lib['ptableCsSel'] = ptableSel.GetSubBitmap(wx.Rect(0, 130, 25, 27))
    lib['ptableBaSel'] = ptableSel.GetSubBitmap(wx.Rect(24, 130, 25, 27))
    lib['ptableLaSel'] = ptableSel.GetSubBitmap(wx.Rect(48, 130, 25, 27))
    lib['ptableHfSel'] = ptableSel.GetSubBitmap(wx.Rect(72, 130, 25, 27))
    lib['ptableTaSel'] = ptableSel.GetSubBitmap(wx.Rect(96, 130, 25, 27))
    lib['ptableWSel'] = ptableSel.GetSubBitmap(wx.Rect(120, 130, 25, 27))
    lib['ptableReSel'] = ptableSel.GetSubBitmap(wx.Rect(144, 130, 25, 27))
    lib['ptableOsSel'] = ptableSel.GetSubBitmap(wx.Rect(168, 130, 25, 27))
    lib['ptableIrSel'] = ptableSel.GetSubBitmap(wx.Rect(192, 130, 25, 27))
    lib['ptablePtSel'] = ptableSel.GetSubBitmap(wx.Rect(216, 130, 25, 27))
    lib['ptableAuSel'] = ptableSel.GetSubBitmap(wx.Rect(240, 130, 25, 27))
    lib['ptableHgSel'] = ptableSel.GetSubBitmap(wx.Rect(264, 130, 25, 27))
    lib['ptableTlSel'] = ptableSel.GetSubBitmap(wx.Rect(288, 130, 25, 27))
    lib['ptablePbSel'] = ptableSel.GetSubBitmap(wx.Rect(312, 130, 25, 27))
    lib['ptableBiSel'] = ptableSel.GetSubBitmap(wx.Rect(336, 130, 25, 27))
    lib['ptablePoSel'] = ptableSel.GetSubBitmap(wx.Rect(360, 130, 25, 27))
    lib['ptableAtSel'] = ptableSel.GetSubBitmap(wx.Rect(384, 130, 25, 27))
    lib['ptableRnSel'] = ptableSel.GetSubBitmap(wx.Rect(408, 130, 25, 27))
    lib['ptableFrSel'] = ptableSel.GetSubBitmap(wx.Rect(0, 156, 25, 27))
    lib['ptableRaSel'] = ptableSel.GetSubBitmap(wx.Rect(24, 156, 25, 27))
    lib['ptableAcSel'] = ptableSel.GetSubBitmap(wx.Rect(48, 156, 25, 27))
    lib['ptableCeSel'] = ptableSel.GetSubBitmap(wx.Rect(72, 202, 25, 27))
    lib['ptablePrSel'] = ptableSel.GetSubBitmap(wx.Rect(96, 202, 25, 27))
    lib['ptableNdSel'] = ptableSel.GetSubBitmap(wx.Rect(120, 202, 25, 27))
    lib['ptablePmSel'] = ptableSel.GetSubBitmap(wx.Rect(144, 202, 25, 27))
    lib['ptableSmSel'] = ptableSel.GetSubBitmap(wx.Rect(168, 202, 25, 27))
    lib['ptableEuSel'] = ptableSel.GetSubBitmap(wx.Rect(192, 202, 25, 27))
    lib['ptableGdSel'] = ptableSel.GetSubBitmap(wx.Rect(216, 202, 25, 27))
    lib['ptableTbSel'] = ptableSel.GetSubBitmap(wx.Rect(240, 202, 25, 27))
    lib['ptableDySel'] = ptableSel.GetSubBitmap(wx.Rect(264, 202, 25, 27))
    lib['ptableHoSel'] = ptableSel.GetSubBitmap(wx.Rect(288, 202, 25, 27))
    lib['ptableErSel'] = ptableSel.GetSubBitmap(wx.Rect(312, 202, 25, 27))
    lib['ptableTmSel'] = ptableSel.GetSubBitmap(wx.Rect(336, 202, 25, 27))
    lib['ptableYbSel'] = ptableSel.GetSubBitmap(wx.Rect(360, 202, 25, 27))
    lib['ptableLuSel'] = ptableSel.GetSubBitmap(wx.Rect(384, 202, 25, 27))
    lib['ptableThSel'] = ptableSel.GetSubBitmap(wx.Rect(72, 228, 25, 27))
    lib['ptablePaSel'] = ptableSel.GetSubBitmap(wx.Rect(96, 228, 25, 27))
    lib['ptableUSel'] = ptableSel.GetSubBitmap(wx.Rect(120, 228, 25, 27))
    lib['ptableNpSel'] = ptableSel.GetSubBitmap(wx.Rect(144, 228, 25, 27))
    lib['ptablePuSel'] = ptableSel.GetSubBitmap(wx.Rect(168, 228, 25, 27))
    lib['ptableAmSel'] = ptableSel.GetSubBitmap(wx.Rect(192, 228, 25, 27))
    lib['ptableCmSel'] = ptableSel.GetSubBitmap(wx.Rect(216, 228, 25, 27))
    lib['ptableBkSel'] = ptableSel.GetSubBitmap(wx.Rect(240, 228, 25, 27))
    lib['ptableCfSel'] = ptableSel.GetSubBitmap(wx.Rect(264, 228, 25, 27))
    lib['ptableEsSel'] = ptableSel.GetSubBitmap(wx.Rect(288, 228, 25, 27))
    lib['ptableFmSel'] = ptableSel.GetSubBitmap(wx.Rect(312, 228, 25, 27))
    lib['ptableMdSel'] = ptableSel.GetSubBitmap(wx.Rect(336, 228, 25, 27))
    lib['ptableNoSel'] = ptableSel.GetSubBitmap(wx.Rect(360, 228, 25, 27))
    lib['ptableLrSel'] = ptableSel.GetSubBitmap(wx.Rect(384, 228, 25, 27))
# ----


def convertImages():
    """Convert an image to PNG format and embed it in a Python file. """
    
    # get libs to import images
    try:
        from wx.lib.embeddedimage import PyEmbeddedImage
        imp = '#load libs\nfrom wx.lib.embeddedimage import PyEmbeddedImage\n\n\n'
    except:
        imp = '#load libs\nimport cStringIO\nfrom wx import ImageFromStream, BitmapFromImage\n\n\n'
    
    # convert images
    for platform in ('mac', 'msw', 'gtk'):
        
        # create file
        imageFile = file('images_lib_'+platform+'.py', 'w')
        imageFile.write(imp)
        imageFile.close()
        
        # make commands
        commands = [
            "-a -u -i -n Icon16 images/"+platform+"/icon_16.png images_lib_"+platform+".py",
            "-a -u -i -n Icon32 images/"+platform+"/icon_32.png images_lib_"+platform+".py",
            "-a -u -i -n Icon48 images/"+platform+"/icon_48.png images_lib_"+platform+".py",
            "-a -u -i -n Icon128 images/"+platform+"/icon_128.png images_lib_"+platform+".py",
            "-a -u -i -n Icon256 images/"+platform+"/icon_256.png images_lib_"+platform+".py",
            "-a -u -i -n Icon512 images/"+platform+"/icon_512.png images_lib_"+platform+".py",
            
            "-a -u -n IconAbout images/"+platform+"/icon_about.png images_lib_"+platform+".py",
            "-a -u -n IconError images/"+platform+"/icon_error.png images_lib_"+platform+".py",
            "-a -u -n IconDlg images/"+platform+"/icon_dlg.png images_lib_"+platform+".py",
            
            "-a -u -n Cursors images/"+platform+"/cursors.png images_lib_"+platform+".py",
            "-a -u -n Arrows images/"+platform+"/arrows.png images_lib_"+platform+".py",
            
            "-a -u -n BgrToolbar images/"+platform+"/bgr_toolbar.png images_lib_"+platform+".py",
            "-a -u -n BgrToolbarNoBorder images/"+platform+"/bgr_toolbar_noborder.png images_lib_"+platform+".py",
            "-a -u -n BgrControlbar images/"+platform+"/bgr_controlbar.png images_lib_"+platform+".py",
            "-a -u -n BgrBottombar images/"+platform+"/bgr_bottombar.png images_lib_"+platform+".py",
            "-a -u -n BgrPeakEditor images/"+platform+"/bgr_peakeditor.png images_lib_"+platform+".py",
            
            "-a -u -n BulletsOn images/"+platform+"/bullets_on.png images_lib_"+platform+".py",
            "-a -u -n BulletsOff images/"+platform+"/bullets_off.png images_lib_"+platform+".py",
            
            "-a -u -n Tools images/"+platform+"/tools.png images_lib_"+platform+".py",
            
            "-a -u -n BottombarsOn images/"+platform+"/bottombars_on.png images_lib_"+platform+".py",
            "-a -u -n BottombarsOff images/"+platform+"/bottombars_off.png images_lib_"+platform+".py",
            "-a -u -n ToolbarsOn images/"+platform+"/toolbars_on.png images_lib_"+platform+".py",
            "-a -u -n ToolbarsOff images/"+platform+"/toolbars_off.png images_lib_"+platform+".py",
            
            "-a -u -n PtableOn images/"+platform+"/periodic_table_on.png images_lib_"+platform+".py",
            "-a -u -n PtableOff images/"+platform+"/periodic_table_off.png images_lib_"+platform+".py",
            "-a -u -n PtableSel images/"+platform+"/periodic_table_sel.png images_lib_"+platform+".py",
        ]
        
        # convert images
        for command in commands:
            img2py.main(command.split())
# ----


if __name__ == "__main__":
    convertImages()