/* Copyright 2005 Matt Flax <flatmax@ieee.org>
   This file is part of MFFM GTK wrapper class set

   MFFM GTK wrapper class set is free software; you can redistribute
   it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   MFFM GTK wrapper class set is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You have received a copy of the GNU General Public License
   along with MFFM GTK wrapper class set
 */
#ifndef BOX_H_
#define BOX_H_

#include <iomanip>
#include <gtk/gtk.h>

class Box {
public:
  GtkWidget *box;
  void packStart(GtkWidget *obj){
    gtk_box_pack_start (GTK_BOX (box), obj, FALSE, FALSE, 0);
  }
public:
  GtkWidget* getWidget(void){return box;}
  void show(void){gtk_widget_show(box);}
  void hide(void){gtk_widget_hide(box);}


  Box& operator <<(Box& b) {
    packStart(b.getWidget());
    return *this;
  }
  Box& operator <<(Box * b) {
    packStart(b->getWidget());
    return *this;
  }
  Box& operator <<(GtkWidget * b) {
    packStart(b);
    return *this;
  }
  Box& operator >>(GtkWidget * b) {
    gtk_container_remove(GTK_CONTAINER(box), b);
    return *this;
  }

  ~Box(void){
    //    gtk_widget_destroy(box);
    //#ifdef DEBUG
    //    cout<<"Box::~Box"<<endl;
    //#endif
  }
};

class VBox : public Box {
public:
  VBox(){
    box = gtk_vbox_new (FALSE, 0);
    //#ifdef DEBUG
    //cout<<"VBox::VBox "<<box<<endl;
    //#endif
  }
};

class HBox  : public Box {
public:
  HBox(){
    box = gtk_hbox_new (FALSE, 0);
    //#ifdef DEBUG
    //cout<<"HBox::HBox "<<box<<endl;
    //#endif
  }
};

#endif //BOX_H_
