/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */
/*
 * $Id: common.h,v 1.11 2000/11/14 03:04:32 kos Exp $
 *
 */

#ifndef _COMMON_H
#define _COMMON_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "array.h"

#ifndef MAX
#define MAX(a, b)  (((a) > (b)) ? (a) : (b))
#endif

#ifndef MIN
#define MIN(a, b)  (((a) < (b)) ? (a) : (b))
#endif

#define tmap(x) (x<'A'?x-'0':10+x-'A')

#define PROTO_VERSION "0.5"
#define NONCE_LEN 16
#define P_OK 0
#define P_MORE 1
#define P_OOB 2
#define P_ERR 101
#define P_EXISTS 102

#define DEF_LINELEN 1024
#define BSTRING_MAXLEN 1024

#define ZAP_LEFT 1
#define ZAP_RIGHT 2

typedef unsigned char kchar;
typedef unsigned char uchar;

typedef struct bstring {
  uchar p[BSTRING_MAXLEN];
  unsigned int l;
} bstring;

#define MSG_REPLACE 1
#define MSG_DEF_REPLACE 0

typedef struct msg_t {
  char *lhs;
  uchar *rhs;
  uint ll;
  uint rl;
} msg_t;

typedef struct msg {
  array *msg;
  int replace;
} msg;

msg *msg_new(void);
int msg_destroy(msg *);
int msg_zero(msg *);
int msg_add_str(msg *, char *lhs, uchar *s, int l);
#define msg_add_strn(x,y,z) msg_add_str(x,y,z,0)
int msg_add_int(msg *, char *lhs, int rhs);
uchar *msg_get(msg *m, uint index);
#define msg_rhs(x,y) msg_get(x,y)
uchar *msg_lhs(msg *m, uint index);
uchar *msg_get_strp(msg *m, char *lhs);
int msg_get_str(msg *, char *lhs, uchar *rhs, int l, int *);
int msg_get_int(msg *, char *lhs);
int msg_get_index(msg *, uint i,  char *lhs, int lhsl, uchar *rhs, int rhsl, int *);
unsigned int msg_getlen(msg *, unsigned int index);
#define msg_add(x,y,z) msg_add_str(x,NULL,y,z)
#define msg_nelems(x) array_nelems((x)->msg)
int msg_getopt(msg *m, uint opt, int *val);
int msg_setopt(msg *m, uint opt, int val);
int msg_dump(msg *m);

int textify(uchar *in, int ilen, uchar *out, int *olen);
int textify_len(uchar *in, int ilen);
int untextify(uchar *in, int ilen, uchar *out, int *olen);
int untextify_len(uchar *in, int ilen);
int base64_decode(uchar *i, int inlen, uchar *out);
int base64_encode(uchar *in, int ilen, uchar *out, int *olen);

bstring *bstring_new(void);
int bstring_zero(bstring *);
int bstring_set_str(bstring *, uchar *, int len);
int bstring_get_str(bstring *, uchar *, int len);
int bstring_cmp(bstring *, bstring *);
int bstring_set(bstring *, bstring *);
int bstring_destroy(bstring *);

int chresp_generate_nonce(bstring *nonce, int len);
int chresp_init(char *realpass, bstring *nonce, bstring *adminhash);
int chresp_authenticate(bstring *adminhash, bstring *response);

int param_get_int(char *optstr, char *name, int *param, int def);
int param_get_str(char *optstr, char *name, char *param, char *def);

/* bit 1 = lhs, bit 2 = rhs */
#define WHITESPACE " \t\n\r"
int isinitc(char p, char *set);
int zap_whitespace(char *victim, int len, int mode);

int buildlapse(char *p, char *str, int len);
int buildtime(char *p, char *str, int len);

#endif /* _COMMON_H */
