#!/usr/bin/perl
# This script tests latest file version from given svn url
# Use: check_version.pl [ -d /path/to/download/ ] -u -v /path/to/svn-urls
# Option -d states where to download (default ".")
# Option -v turns on verbose mode
# Option -u forces update of each file

use Getopt::Std;
%options=();
getopts("d:vu",\%options);

my $directory = $options{d} || ".";
my @new;
my @added;
my @refused;
my $file = shift;

open (F, $file);

sub latest_revision {
  my $url = shift ;
  my $latest_revision = `LC_ALL=C svn info $url | grep "Last Changed Rev" | sed -e "s#Last Changed Rev: ##"`;
  $latest_revision =~ s/[\r\n\/]+$//;
  return $latest_revision ;
}

sub add_other {
  my ($base,$files) = @_;
  my @lines = split("\n",$files);
  my %is_refused;
  for (@refused) { $is_refused{$_} = 1; }
  my %is_added;
  my @blacklist = qw/README COPYING CHANGELOG TODO/;
  for (@added) { $is_added{$_} = 1; }
  print "Checking other files in the same directory...\n" ;
  foreach $new_file (@lines) {
    my $exists = `cat "$file" | grep "$new_file"` ;
    my @filtered = grep(/$new_file/,@blacklist);
    print "Checking: $new_file\n";
    my $size = @filtered;
    print "Filtered\n" unless $size == 0;
    print "Already refused\n" unless $is_refused{"$base/$new_file"} != 1;
    print "Already present\n" unless "$exists" eq "";
    if ("$exists" eq "" && $is_refused{"$base/$new_file"} != 1 
          && $is_added{"$base/$new_file"} != 1
	  && $size == 0) {
      print "Add $new_file ? (y/n)\n";
      my $add = <> ;
      $add =~ s/[\r\n]+$//;
      if ("$add" eq "y") {
        print "Type ? (include|extensions|maintenance/*|http/*)\n" ;
        my $type = <> ;
	$type =~ s/[\r\n]+$//;
	if ("$type" eq "extensions" || "$type" eq "include" || 
             $type =~ /maintenance\/.*/ || $type =~ /http\/.*/) {
	  my $revision = latest_revision("$base/$new_file");
	  push @new,"$base/$new_file - $type - $revision\n" ;
	  push @added,"$base/$new_file" ;
	  download_latest ("$base/$new_file",$type,$revision) ;
	} else { 
	  push @refused,"$base/$new_file";
	  print "Invalid type !\n" ; 
	}
      } else {
        push @refused,"$base/$new_file";
	print "Not adding file..\n";
      }
   }
 }
}

while (<F>) {
  print "Processing line: $_" if defined $options{v};
  next if (/^\s*#/);
  /^(.+)\s-\s(.+)\s-\s(\d+)/;
  my ($url,$type,$revision) = ($1,$2,$3);
  $revision = 0 if defined $options{u};
  my $latest_revision = latest_revision($url);
  my $dirname = `dirname $url` ;
  $dirname =~ s/[\n\r]+$//;
  my $list = `LC_ALL=C svn list $dirname` ;
  # Avoid listing files in extensions/
  my $dir = `basename $dirname` ;
  $dir =~ s/[\n\r\/]+$//;
  add_other ($dirname,$list) unless "$dir" eq "extensions" ;
  push @new,"$url - $type - $latest_revision\n" ;
  print "$url:\noutdated: local revison = $revision, newest = $latest_revision\n" and
  download_latest($url,$type,$revision) unless ($latest_revision == $revision);
  print "$url:\nup to date at revision $latest_revision\n\n" ;
}

close(F);
open (F,">$file");
print F "# svn-revisions, generated by check_version.pl\n";
foreach (@new) {
  print F $_;
}
close(F);

sub download_latest {
  my ($url,$type,$old) = @_;
  print "Downloading $type file\n\n";
  $url =~ /^http:\/\/.*\/(.*)$/;
  my $file = $1;
  system("mkdir -p $directory/$type > /dev/null 2>&1");
  system("cd $directory/$type && svn export $url > /dev/null 2>&1");
}

