#!/usr/bin/perl
# This script tests latest file version from given svn url
# Use: check_version.pl [ -d /path/to/download/ ] < svn-urls
# Option -d is optional, ask for download of new files.


use Getopt::Std;
%options=();
getopts("fd:",\%options);

my $directory = $options{d} || ".";
my @outdated;

while (<>) {
  next if (/^\s*#/);
  /^(.+)\s-\s(.+)\s-\s(\d+)/;
  my ($url,$type,$revision) = ($1,$2,$3);
  my $latest_revision = `LC_ALL=C svn info $url | grep "Last Changed Rev" | sed -e "s#Last Changed Rev: ##"`;
  push @outdated,$url and 
  print "$url:\noutdated: local revison = $revision, newest = $latest_revision\n" and
  download_latest($url,$type,$revision) and
  next unless ($latest_revision <= $revision);
  print "$url:\nup to date at revision $revision\n\n" unless ($latest_revision > $revision);
  download_latest($url,$type,$revision) unless (!$options{f});
}


sub download_latest {
  my ($url,$type,$old) = @_;
  print "Downloading $type file\n";
  $url =~ /^http:\/\/.*\/(.*)$/;
  my $file = $1;
  system("mkdir -p $directory/$type > /dev/null 2>&1");
  system("cd $directory/$type && svn export $url > /dev/null 2>&1");
}

