/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.gui.menue;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mediathek.daten.Daten;
import mediathek.Konstanten;
import mediathek.filme.BeobFilmeLaden;
import mediathek.filme.sender.MediathekReader;
import mediathek.gui.PanelVorlage;

public class PanelSenderLaden extends PanelVorlage {

    private BeobCheckboxSender[] beobCheck;

    public PanelSenderLaden(Daten d) {
        super(d);
        initComponents();
        daten = d;
        beobCheck = new BeobCheckboxSender[daten.filmeLaden.mediathekListe.size()];
        for (int i = 0; i < daten.filmeLaden.mediathekListe.size(); ++i) {
            beobCheck[i] = new BeobCheckboxSender(i);
        }
        init();
        jSpinnerWarten.addChangeListener(new BeobSpinnerWarten());
        jCheckBoxNurAbos.addActionListener(new BeobCheckBox());
        jButtonStarten.addActionListener(new BeobStarten());
        daten.filmeLaden.addAdListener(new BeobachterLaden());
    }

    @Override
    public void neuLaden() {
        init();
    }

    private void init() {
        jCheckBoxNurAbos.setSelected(Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_NUR_ABO_NR]));
        if (daten.system[Konstanten.SYSTEM_WARTEN_NR].equals("")) {
            jSpinnerWarten.setValue(1);
            daten.system[Konstanten.SYSTEM_WARTEN_NR] = "1";
        } else {
            jSpinnerWarten.setValue(Integer.parseInt(daten.system[Konstanten.SYSTEM_WARTEN_NR]));
        }
        addSender();
    }

    private void addSender() {
        panelSender.removeAll();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0;
        panelSender.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = GridBagConstraints.WEST;
        c.fill = GridBagConstraints.NONE;
        Iterator<MediathekReader> it = daten.filmeLaden.mediathekListe.iterator();
        MediathekReader reader;
        int nr = 0;
        int y = 0;
        int halbe = daten.filmeLaden.mediathekListe.size() / 2;
        while (it.hasNext()) {
            c.gridy = y;
            reader = it.next();
            addPanel(gridbag, c, reader, nr);
            ++nr;
            ++y;
            if (y > halbe) {
                y = 0;
                c.gridx = 1;
            }
        }
        JLabel label = new JLabel();
        c.gridx = 4;
        c.weightx = 2;
        gridbag.setConstraints(label, c);
        panelSender.add(label);
        panelSender.updateUI();
    }

    private void addPanel(GridBagLayout gridbag, GridBagConstraints c, MediathekReader reader, int nr) {
        JCheckBox box;
        box = new JCheckBox(reader.text);
        box.setSelected(reader.istSenderAn());
        box.addActionListener(beobCheck[nr]);
        c.insets = new Insets(2, 10, 2, 2);
        gridbag.setConstraints(box, c);
        panelSender.add(box);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jLayeredPane1 = new javax.swing.JLayeredPane();
        panelSender = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jCheckBoxNurAbos = new javax.swing.JCheckBox();
        jSpinnerWarten = new javax.swing.JSpinner();
        jLabel7 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jButtonStarten = new javax.swing.JButton();

        panelSender.setBorder(javax.swing.BorderFactory.createTitledBorder("Sender"));

        javax.swing.GroupLayout panelSenderLayout = new javax.swing.GroupLayout(panelSender);
        panelSender.setLayout(panelSenderLayout);
        panelSenderLayout.setHorizontalGroup(
            panelSenderLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 652, Short.MAX_VALUE)
        );
        panelSenderLayout.setVerticalGroup(
            panelSenderLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 28, Short.MAX_VALUE)
        );

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("Beim direkten Laden vom Sender"));

        jCheckBoxNurAbos.setText("nur Abos laden");

        jSpinnerWarten.setModel(new javax.swing.SpinnerNumberModel(Integer.valueOf(1), Integer.valueOf(1), null, Integer.valueOf(1)));

        jLabel7.setText("Laden um den Faktor bremsen");

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jCheckBoxNurAbos)
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addComponent(jSpinnerWarten, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel7)))
                .addContainerGap(380, Short.MAX_VALUE))
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jCheckBoxNurAbos)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel7)
                    .addComponent(jSpinnerWarten, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel1.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));

        jLabel1.setText("Filme von den Websiten der Sender laden, kann etwas dauern!");

        jButtonStarten.setText("jetzt Laden");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 69, Short.MAX_VALUE)
                .addComponent(jButtonStarten)
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jButtonStarten))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(panelSender, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel4, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(panelSender, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButtonStarten;
    private javax.swing.JCheckBox jCheckBoxNurAbos;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLayeredPane jLayeredPane1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JSpinner jSpinnerWarten;
    private javax.swing.JPanel panelSender;
    // End of variables declaration//GEN-END:variables

    private class BeobCheckboxSender implements ActionListener {

        private int nr;

        public BeobCheckboxSender(int nnr) {
            nr = nnr;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            daten.filmeLaden.mediathekListe.get(nr).setSenderAn(((JCheckBox) e.getSource()).isSelected());
            daten.setGeaendert();
        }
    }

    private class BeobCheckBox implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!stopBeob) {
                daten.system[Konstanten.SYSTEM_NUR_ABO_NR] = Boolean.toString(jCheckBoxNurAbos.isSelected());
                daten.setGeaendert();
            }
        }
    }

    private class BeobStarten implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            daten.filmeLaden.filmeBeimSenderLaden();
            daten.setGeaendert();
        }
    }

//    private class BeobEinstellungenSender implements ActionListener {
//
//        private int nr;
//
//        public BeobEinstellungenSender(int nnr) {
//            nr = nnr;
//        }
//
//        @Override
//        public void actionPerformed(ActionEvent e) {
//            MediathekReader reader = daten.filmeLaden.mediathekListe.get(nr);
//            if (reader.panelEinstellungen != null) {
//                reader.panelEinstellungen.setVisible(true);
//            }
//        }
//    }

    private class BeobSpinnerWarten implements ChangeListener {

        @Override
        public void stateChanged(ChangeEvent arg0) {
            daten.system[Konstanten.SYSTEM_WARTEN_NR] =
                    String.valueOf(((Number) jSpinnerWarten.getModel().getValue()).intValue());
            daten.setGeaendertOhnePanel();
        }
    }

    private class BeobachterLaden extends BeobFilmeLaden {

        @Override
        public void starten() {
            jButtonStarten.setEnabled(false);
        }

        @Override
        public void beenden() {
            jButtonStarten.setEnabled(true);
        }
    }
}
