/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import mediathek.daten.Daten;
import mediathek.gui.dialoge.DialogHinweis;
import mediathek.wiz.WizButtonAnlegen;

public class GuiDebug extends PanelVorlage {

    /**
     * Creates new form GuiFeed
     * @param d
     */
    public GuiDebug(Daten d) {
        super(d);
        initComponents();
        daten = d;
        jButtonSpeichern.addActionListener(new BeobAllesSpeichern());
        jButtonWizard.addActionListener(new BeobWizard());
        jCheckBoxProg.addActionListener(new BeobProg());
        jButtonHinweis.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHinweis(null, true, daten, "Text", "http://zdfmediathk.sourceforge.net/flvstreamer.html").setVisible(true);
//                new DialogHinweis(null, true, daten, "Text", "").setVisible(true);
            }
        });
    }
    //===================================
    // Public
    //===================================

    //===================================
    // Private
    //===================================
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jButtonSpeichern = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jCheckBoxProg = new javax.swing.JCheckBox();
        jButtonWizard = new javax.swing.JButton();
        jButtonHinweis = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();

        jButtonSpeichern.setText("alles speichern");

        jPanel1.setBorder(javax.swing.BorderFactory.createEmptyBorder(5, 5, 5, 5));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 135, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 104, Short.MAX_VALUE)
        );

        jCheckBoxProg.setFont(new java.awt.Font("Dialog", 3, 12)); // NOI18N
        jCheckBoxProg.setForeground(new java.awt.Color(153, 0, 0));
        jCheckBoxProg.setText("Programmausgabe auf der Konsole ausgeben");

        jButtonWizard.setText("Wizard");

        jButtonHinweis.setText("Hinweis");

        jPanel2.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jButtonSpeichern)
                        .addGap(18, 18, 18)
                        .addComponent(jButtonWizard))
                    .addComponent(jButtonHinweis)
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                        .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                            .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addComponent(jCheckBoxProg, javax.swing.GroupLayout.Alignment.LEADING)))
                .addContainerGap(337, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonSpeichern)
                    .addComponent(jButtonWizard))
                .addGap(18, 18, 18)
                .addComponent(jCheckBoxProg)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(66, 66, 66)
                        .addComponent(jButtonHinweis)
                        .addGap(26, 26, 26)
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(101, 101, 101)
                        .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(190, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonHinweis;
    private javax.swing.JButton jButtonSpeichern;
    private javax.swing.JButton jButtonWizard;
    private javax.swing.JCheckBox jCheckBoxProg;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    // End of variables declaration//GEN-END:variables

    private class BeobAllesSpeichern implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            daten.speichern();
            daten.ioXml.filmeSchreiben();
        }
    }

    private class BeobProg implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            daten.progAusgabe = jCheckBoxProg.isSelected();
        }
    }

    private class BeobWizard implements ActionListener {

        @Override
        public void actionPerformed(ActionEvent e) {
            new WizButtonAnlegen(daten);
        }
    }
}
