/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek;

import mediathek.filme.DatenFilm;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import mediathek.daten.*;
import mediathek.gui.dialoge.DialogHilfe;

public class Funktionen {

    public static DefaultTableModel getEmptyModel(String[] titel) {
        int n = titel.length;
        String[][] obj = new String[1][n];
        for (int i = 0; i < n; ++i) {
            obj[0][i] = "";
        }
        return new DefaultTableModel(obj, titel);
    }

    public static boolean setLook(Daten daten, JFrame frame) {
        int look = 0;
        if (daten.system[Konstanten.SYSTEM_LOOK_NR].equals("")) {
            daten.system[Konstanten.SYSTEM_LOOK_NR] = "1";
        }
        look = Integer.parseInt(daten.system[Konstanten.SYSTEM_LOOK_NR]);
        if (look != 0) {
            return setLook(daten, frame, look);
        } else {
            return true;
        }
    }

    public static boolean setLook(Daten daten, JFrame frame, int look) {
        boolean ret = false;
        try {
            switch (look) {
                case 0:
                case 1:
                    //bei 0 egentlich nichts tun, wenn aber gewechselt, dann zurückschalten
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    break;
                default:
                    UIManager.setLookAndFeel(Konstanten.THEME[look][1]);
                    break;
            }
            SwingUtilities.updateComponentTreeUI(frame);
            for (Frame f : Frame.getFrames()) {
                SwingUtilities.updateComponentTreeUI(f);
                for (Window w : f.getOwnedWindows()) {
                    SwingUtilities.updateComponentTreeUI(w);
                }
            }
            ret = true;
        } catch (Exception e) {
            daten.fehler.fehlerMeldung(e, "Kann das Look and Feel nicht ändern!");
        }
        return ret;
    }

    public static void copyToClipboard(String s) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(s), null);
    }

    public static void setProxy(Daten daten) {
        if (Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_PROXY_ON_NR])) {
//            System.setProperty("proxySet", "true");
//            System.setProperty("proxyHost", daten.system[Konstanten.SYSTEM_PROXY_SERVER_NR]);
//            System.setProperty("proxyPort", daten.system[Konstanten.SYSTEM_PROXY_PORT_NR]);
//

            System.setProperty("proxySet", "true");
            System.setProperty("http.proxyHost", daten.system[Konstanten.SYSTEM_PROXY_SERVER_NR]);
            System.setProperty("http.proxyPort", daten.system[Konstanten.SYSTEM_PROXY_PORT_NR]);
            System.setProperty("http.proxyUser", daten.system[Konstanten.SYSTEM_PROXY_USER_NR]);
            System.setProperty("http.proxyPassword", daten.system[Konstanten.SYSTEM_PROXY_PWD_NR]);
        } else {
            System.setProperty("proxySet", "false");
        }
    }

    public static String replaceLeerDateiname(String pfad, boolean keinPfadtrenner) {
        //verbotene Zeichen entfernen
        String ret = pfad;
        if (keinPfadtrenner) {
            ret = ret.replace("/", "-");
            ret = ret.replace("\\", "-");
        }
        ret = ret.replace("\"", "_");
        ret = ret.replace(",", "_");
        ret = ret.replace(";", "_");
        ret = ret.replace("(", "_");
        ret = ret.replace(")", "_");
        ret = ret.replace(" ", "_");
        ret = ret.replace("*", "_");
        ret = ret.replace("?", "_");
        ret = ret.replace("<", "_");
        ret = ret.replace(">", "_");
        ret = ret.replace(":", "_");
        ret = ret.replace("'", "_");
        return ret;
    }

    public static String addsPfad(Daten daten, String pfad1, String pfad2) {
        String ret = "";
        if (pfad1 != null && pfad2 != null) {
            if (!pfad1.equals("") && !pfad2.equals("")) {
                if (pfad1.charAt(pfad1.length() - 1) == File.separatorChar) {
                    ret = pfad1.substring(0, pfad1.length() - 1);
                } else {
                    ret = pfad1;
                }
                if (pfad2.charAt(0) == File.separatorChar) {
                    ret += pfad2;
                } else {
                    ret += File.separator + pfad2;
                }
            }
        }
        if (ret.equals("")) {
            daten.fehler.fehlerMeldung("Fehler!", "Funktionen.addsPfad: " + pfad1 + " " + pfad2);
        }
        return ret;
    }

    public static String addsUrl(Daten daten, String pfad1, String pfad2) {
        String ret = "";
        if (pfad1 != null && pfad2 != null) {
            if (!pfad1.equals("") && !pfad2.equals("")) {
                if (pfad1.charAt(pfad1.length() - 1) == '/') {
                    ret = pfad1.substring(0, pfad1.length() - 1);
                } else {
                    ret = pfad1;
                }
                if (pfad2.charAt(0) == '/') {
                    ret += pfad2;
                } else {
                    ret += '/' + pfad2;
                }
            }
        }
        if (ret.equals("")) {
            daten.fehler.fehlerMeldung("Fehler!", "Funktionen.addsUrl: " + pfad1 + " " + pfad2);
        }
        return ret;
    }

    public static String getDateiName(Daten daten, String pfad) {
        //Dateinamen einer URL extrahieren
        String ret = "";
        if (pfad != null) {
            if (!pfad.equals("")) {
                ret = pfad.substring(pfad.lastIndexOf("/") + 1);
            }
        }
        if (ret.contains("?")) {
            ret = ret.substring(0, ret.indexOf("?"));
        }
        if (ret.contains("&")) {
            ret = ret.substring(0, ret.indexOf("&"));
        }
        if (ret.equals("")) {
            daten.fehler.fehlerMeldung("Fehler!", "Funktionen.getDateiName: " + pfad);
        }
        return ret;
    }

    public static void listeSort(LinkedList<String> liste) {
        //Stringliste alphabetisch sortieren
        LinkedList<String> listeRet = new LinkedList<String>();
        ListIterator<String> it;
        if (liste != null) {
            it = liste.listIterator();
            while (it.hasNext()) {
                listeRet.add(it.next());
            }
            it = listeRet.listIterator();
            liste.clear();
            while (it.hasNext()) {
                addSort(liste, it.next(), 0, liste.size());
            }
        }
    }

    private static void addSort(LinkedList<String> liste, String str, int ab, int bis) {
        if (ab == bis) {
            liste.add(ab, str);
        } else if (ab + 1 == bis) {
            if (liste.get(ab).compareToIgnoreCase(str) > 0) {
                liste.add(ab, str);
            } else {
                liste.add(ab + 1, str);
            }
        } else {
            int mitte = (ab + bis) / 2;
            if (liste.get(mitte).compareToIgnoreCase(str) > 0) {
                addSort(liste, str, ab, mitte);
            } else {
                addSort(liste, str, mitte, bis);
            }
        }
    }

    public static void listeSort(LinkedList<String[]> liste, int stelle) {
        //Stringliste alphabetisch sortieren
        if (liste != null) {
            String str1;
            String str2;
            for (int i = 1; i < liste.size(); ++i) {
                for (int k = i; k > 0; --k) {
                    str1 = liste.get(k - 1)[stelle];
                    str2 = liste.get(k)[stelle];
                    if (str1.compareToIgnoreCase(str2) > 0) {
                        liste.add(k - 1, liste.remove(k));
                    } else {
                        break;
                    }
                }
            }
        }
    }

    public static void addStandardprogrammeAbo(Daten daten) {
        // Erster Start und noch nichts eingerichtet, initialisieren
        System.out.println(System.getProperty("os.name"));
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            addStandardprogrammeAboWin(daten);
        } else if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            addStandardprogrammeAboLinux(daten);
        } else {
            addStandardprogrammeAboWin(daten);
            addStandardprogrammeAboLinux(daten);
        }
    }

    public static void addStandardPodcast(Daten daten) {
        // Erster Start und noch nichts eingerichtet, initialisieren
        System.out.println(System.getProperty("os.name"));
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            daten.system[Konstanten.SYSTEM_ZIELPFAD_POD_NR] = "c:\\";
        } else if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            daten.system[Konstanten.SYSTEM_ZIELPFAD_POD_NR] = "/tmp";
        } else {
        }
    }

    private static void addStandardprogrammeAboWin(Daten daten) {
        // Neustart und noch kein File, initialisieren
        DatenProg prog;
        DatenPgruppe gruppe;
        //Gruppe Windows
        gruppe = new DatenPgruppe();
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_NAME_NR] = "Programmgruppe Windows";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_DATEINAME_NR] = "%T-%N.mp4";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_PFAD_NR] = "c:\\";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_PRAEFIX_DIREKT_NR] = Konstanten.DIREKTE_DOWNLOAD_PRAEFIX;
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_SUFFIX_DIREKT_NR] = Konstanten.DIREKTE_DOWNLOAD_SUFFIX;
        //Prog
        prog = new DatenProg();
        prog.arr[Konstanten.PROGRAMM_NAME_NR] = "flvstreamer";
        prog.arr[Konstanten.PROGRAMM_PROGRAMMPFAD_NR] = "flvstreamer_win32_latest.exe";
        prog.arr[Konstanten.PROGRAMM_SCHALTER_NR] = "%f -o \"**\" --resume";
        prog.arr[Konstanten.PROGRAMM_PRAEFIX_NR] = "-";
        prog.arr[Konstanten.PROGRAMM_SUFFIX_NR] = "";
        gruppe.addProg(prog);
        //Prog
        prog = new DatenProg();
        prog.arr[Konstanten.PROGRAMM_NAME_NR] = "vlc";
        prog.arr[Konstanten.PROGRAMM_PROGRAMMPFAD_NR] = "C:\\Programme\\VideoLAN\\VLC\\vlc.exe";
        prog.arr[Konstanten.PROGRAMM_SCHALTER_NR] = "%f :sout=#transcode{acodec=mpga,ab=128,channels=2}:duplicate{dst=std{access=file,mux=ts,dst=\"**\"}} -I \"dummy\" --play-and-exit";
        prog.arr[Konstanten.PROGRAMM_PRAEFIX_NR] = "";
        prog.arr[Konstanten.PROGRAMM_SUFFIX_NR] = "";
        gruppe.addProg(prog);
        daten.listePgruppeAbo.add(gruppe);
    }

    private static void addStandardprogrammeAboLinux(Daten daten) {
        // Neustart und noch kein File, initialisieren
        DatenProg prog;
        DatenPgruppe gruppe;
        //Gruppe Linux
        gruppe = new DatenPgruppe();
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_NAME_NR] = "Programmgruppe Linux";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_DATEINAME_NR] = "%T-%N";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_PFAD_NR] = "/tmp";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_PRAEFIX_DIREKT_NR] = Konstanten.DIREKTE_DOWNLOAD_PRAEFIX;
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_SUFFIX_DIREKT_NR] = Konstanten.DIREKTE_DOWNLOAD_SUFFIX;
        //Prog
        prog = new DatenProg();
        prog.arr[Konstanten.PROGRAMM_NAME_NR] = "flvstreamer";
        prog.arr[Konstanten.PROGRAMM_PROGRAMMPFAD_NR] = "flvstreamer";
        prog.arr[Konstanten.PROGRAMM_SCHALTER_NR] = "%f -o ** --resume";
        prog.arr[Konstanten.PROGRAMM_PRAEFIX_NR] = "-";
        prog.arr[Konstanten.PROGRAMM_SUFFIX_NR] = "";
        gruppe.addProg(prog);
        //Prog
        prog = new DatenProg();
        prog.arr[Konstanten.PROGRAMM_NAME_NR] = "Aufzeichnen Vlc";
        prog.arr[Konstanten.PROGRAMM_PROGRAMMPFAD_NR] = "vlc";
        prog.arr[Konstanten.PROGRAMM_SCHALTER_NR] = "%f :sout=#transcode{acodec=mpga,ab=128,channels=2}:duplicate{dst=std{access=file,mux=ts,dst=**}} -I dummy --play-and-exit";
        prog.arr[Konstanten.PROGRAMM_PRAEFIX_NR] = "mms";
        prog.arr[Konstanten.PROGRAMM_SUFFIX_NR] = "";
        gruppe.addProg(prog);
        //Prog
        prog = new DatenProg();
        prog.arr[Konstanten.PROGRAMM_NAME_NR] = "mplayer";
        prog.arr[Konstanten.PROGRAMM_PROGRAMMPFAD_NR] = "mplayer";
        prog.arr[Konstanten.PROGRAMM_SCHALTER_NR] = "-playlist %f -dumpstream -dumpfile **";
        prog.arr[Konstanten.PROGRAMM_PRAEFIX_NR] = "";
        prog.arr[Konstanten.PROGRAMM_SUFFIX_NR] = "";
        gruppe.addProg(prog);
        daten.listePgruppeAbo.add(gruppe);
    }

    public static void addStandardprogrammeButton(Daten daten) {
        // Erster Start und noch nichts eingerichtet, initialisieren
        System.out.println(System.getProperty("os.name"));
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            addStandardprogrammeButtonWin(daten);
        } else if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            addStandardprogrammeButtonLinux(daten);
        } else if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            addStandardprogrammeButtonMac(daten);
        } else {
            addStandardprogrammeButtonWin(daten);
            addStandardprogrammeButtonLinux(daten);
            addStandardprogrammeButtonMac(daten);
        }
    }

    private static void addStandardprogrammeButtonMac(Daten daten) {
        // Erster Start und noch nichts eingerichtet, initialisieren
        DatenPgruppe gruppe;

        gruppe = new DatenPgruppe();
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_NAME_NR] = "Abspielen Vlc";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_DATEINAME_NR] = "";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_PFAD_NR] = "";
        gruppe.addProg(new DatenProg("Mac - Abspielen Vlc", "/Applications/VLC.app/Contents/MacOS/VLC", "%f"));
        daten.listePgruppeButton.add(gruppe);
    }

    private static void addStandardprogrammeButtonLinux(Daten daten) {
        // Erster Start und noch nichts eingerichtet, initialisieren
        DatenPgruppe gruppe;

        gruppe = new DatenPgruppe();
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_NAME_NR] = "Abspielen Vlc";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_DATEINAME_NR] = "";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_PFAD_NR] = "";
        gruppe.addProg(new DatenProg("Linux - Abspielen Vlc", "/usr/bin/vlc", "%f"));
        daten.listePgruppeButton.add(gruppe);

        gruppe = new DatenPgruppe();
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_NAME_NR] = "Aufzeichnen mplayer /tmp";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_DATEINAME_NR] = "%n";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_PFAD_NR] = "/tmp/";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_PRAEFIX_DIREKT_NR] = Konstanten.DIREKTE_DOWNLOAD_PRAEFIX;
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_SUFFIX_DIREKT_NR] = Konstanten.DIREKTE_DOWNLOAD_SUFFIX;
        gruppe.addProg(new DatenProg("Linux - Aufzeichnen mplayer", "mplayer", "-playlist %f -dumpstream -dumpfile **"));
        daten.listePgruppeButton.add(gruppe);

        gruppe = new DatenPgruppe();
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_NAME_NR] = "Aufzeichnen mplayer mit Pfad";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_DATEINAME_NR] = "%p";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_PFAD_NR] = "";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_PRAEFIX_DIREKT_NR] = Konstanten.DIREKTE_DOWNLOAD_PRAEFIX;
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_SUFFIX_DIREKT_NR] = Konstanten.DIREKTE_DOWNLOAD_SUFFIX;
        gruppe.addProg(new DatenProg("Linux - Aufzeichnen mplayer mit Pfad", "/usr/bin/mplayer", "-playlist %f -dumpstream -dumpfile **"));
        daten.listePgruppeButton.add(gruppe);

        gruppe = new DatenPgruppe();
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_NAME_NR] = "Aufzeichnen VLC mit Pfad";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_DATEINAME_NR] = "%p";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_PFAD_NR] = "";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_PRAEFIX_DIREKT_NR] = Konstanten.DIREKTE_DOWNLOAD_PRAEFIX;
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_SUFFIX_DIREKT_NR] = Konstanten.DIREKTE_DOWNLOAD_SUFFIX;
        gruppe.addProg(new DatenProg("Linux - nicht transcodiertes Aufnehmen ohne Anschauen", "vlc",
                "%f :sout=#duplicate{dst=std{access=file,mux=asf,dst=**}} -I dummy --play-and-exit"));
        daten.listePgruppeButton.add(gruppe);

        //flvstreamer
        gruppe = new DatenPgruppe();
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_NAME_NR] = "Aufzeichnen flvstreamer /tmp";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_DATEINAME_NR] = "%n";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_PFAD_NR] = "/tmp/";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_PRAEFIX_DIREKT_NR] = Konstanten.DIREKTE_DOWNLOAD_PRAEFIX;
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_SUFFIX_DIREKT_NR] = Konstanten.DIREKTE_DOWNLOAD_SUFFIX;
        gruppe.addProg(new DatenProg("flvstreamer", "flvstreamer", "%f -o ** --resume"));
        daten.listePgruppeButton.add(gruppe);

        daten.listePgruppeButton.setDoppelklick(0);
    }

    private static void addStandardprogrammeButtonWin(Daten daten) {
        // Erster Start und noch nichts eingerichtet, initialisieren
        DatenPgruppe gruppe;

        gruppe = new DatenPgruppe();
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_NAME_NR] = "Abspielen Vlc";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_DATEINAME_NR] = "";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_PFAD_NR] = "";
        gruppe.addProg(new DatenProg("Win - Abspielen Vlc", "C:\\Programme\\VideoLAN\\VLC\\vlc.exe", "%f"));
        daten.listePgruppeButton.add(gruppe);

        gruppe = new DatenPgruppe();
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_NAME_NR] = "Aufzeichnen Vlc";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_DATEINAME_NR] = "%p.mp4";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_PFAD_NR] = "";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_PRAEFIX_DIREKT_NR] = Konstanten.DIREKTE_DOWNLOAD_PRAEFIX;
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_SUFFIX_DIREKT_NR] = Konstanten.DIREKTE_DOWNLOAD_SUFFIX;
        gruppe.addProg(
                new DatenProg("Win - Aufzeichnen Vlc mit Pfad",
                "C:\\Programme\\VideoLAN\\VLC\\vlc.exe",
                "%f :sout=#transcode{acodec=mpga,ab=128,channels=2}:duplicate{dst=std{access=file,mux=ts,dst=\"**\"}} -I \"dummy\" --play-and-exit"));
        daten.listePgruppeButton.add(gruppe);

        //flvstreamer
        gruppe = new DatenPgruppe();
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_NAME_NR] = "Aufzeichnen flvstreamer";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_DATEINAME_NR] = "%p.mp4";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_ZIEL_PFAD_NR] = "C:\\";
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_PRAEFIX_DIREKT_NR] = Konstanten.DIREKTE_DOWNLOAD_PRAEFIX;
        gruppe.arr[Konstanten.PROGRAMMGRUPPE_SUFFIX_DIREKT_NR] = Konstanten.DIREKTE_DOWNLOAD_SUFFIX;
        gruppe.addProg(
                new DatenProg("flvstreamer",
                "flvstreamer_win32_latest.exe",
                "%f -o \"**\" --resume"));
        daten.listePgruppeButton.add(gruppe);

        daten.listePgruppeButton.setDoppelklick(0);
    }

    public static void addProgVorlagen(Daten daten) {
        // Liste der Sandardprogramme
        // erst leeren
        daten.listeProgVorlagen.clear();
        // Windows
        daten.listeProgVorlagen.addProg("Win - Abspielen Vlc", "C:\\Programme\\VideoLAN\\VLC\\vlc.exe", "%f");
        daten.listeProgVorlagen.addProg("Win - Aufzeichnen Vlc",
                "C:\\Programme\\VideoLAN\\VLC\\vlc.exe",
                "%f :sout=#transcode{acodec=mpga,ab=128,channels=2}:duplicate{dst=std{access=file,mux=ts,dst=\"**\"}} -I \"dummy\" --play-and-exit");

        daten.listeProgVorlagen.addProg("Win - nicht transcodiertes Aufnehmen ohne Anschauen",
                "C:\\Programme\\VideoLAN\\VLC\\vlc.exe",
                "%f :sout=#duplicate{dst=std{access=file,mux=asf,dst=\"**\"}} -I \"dummy\" --play-and-exit");
        daten.listeProgVorlagen.addProg("Win - nicht transcodiertes Aufnehmen und Anschauen",
                "C:\\Programme\\VideoLAN\\VLC\\vlc.exe",
                "%f :sout=#duplicate{dst=std{access=file,mux=asf,dst=\"**\"},dst=display} --play-and-exit");
        daten.listeProgVorlagen.addProg("Win - Itunes lauffähiges Video",
                "C:\\Programme\\VideoLAN\\VLC\\vlc.exe",
                "%f :sout=#transcode{vcodec=mp4v,vb=1024,scale=1,width=480,height=272,acodec=mp4a,ab=128,channels=2,samplerate=48000}:duplicate{dst=std{access=file,mux=mp4,dst=\"**\"}} --play-and-exit");
        DatenProg prog = new DatenProg("Windows - Aufzeichnen flvstreamer", "C:\\Users\\test\\Downloads\\flvstreamer_win32_latest.exe",
                "%f -o \"**\" --resume");
        prog.arr[Konstanten.PROGRAMM_PRAEFIX_NR] = "-";
        daten.listeProgVorlagen.add(prog);
        //
        //Linux
        daten.listeProgVorlagen.addProg("Linux - Abspielen Vlc", "/usr/bin/vlc", "%f");
        daten.listeProgVorlagen.addProg("Linux - Aufzeichnen mplayer", "/usr/bin/mplayer", "-playlist %f -dumpstream -dumpfile **");
        daten.listeProgVorlagen.addProg("Linux - nicht transcodiertes Aufnehmen ohne Anschauen",
                "vlc",
                "%f :sout=#duplicate{dst=std{access=file,mux=asf,dst=**}} -I dummy --play-and-exit");
        prog = new DatenProg("Linux - Aufzeichnen flvstreamer", "/usr/bin/flvstreamer", "%f -o ** --resume");
        prog.arr[Konstanten.PROGRAMM_PRAEFIX_NR] = "-";
        daten.listeProgVorlagen.add(prog);

        //
        //Mac
        daten.listeProgVorlagen.addProg("Mac - Abspielen Vlc", "/Applications/VLC.app/Contents/MacOS/VLC", "%f");
        //
    }

    public static boolean programmePruefen(Daten daten, ListePgruppe listeProg) {
        boolean ret = true;
        String text = "";
        Iterator<DatenPgruppe> it = listeProg.iterator();
        DatenPgruppe gruppe;
        DatenProg prog;
        while (it.hasNext()) {
            gruppe = it.next();
            Iterator<DatenProg> itProg = gruppe.getListeProg().iterator();
            while (itProg.hasNext()) {
                prog = itProg.next();
                if (!prog.arr[Konstanten.PROGRAMM_PROGRAMMPFAD_NR].equals("")) { //kein Label
                    if (!new File(prog.arr[Konstanten.PROGRAMM_PROGRAMMPFAD_NR]).canExecute()) {
                        //Programmfehler
                        ret = false;
                        text += "Falscher Programmpfad!\n";
                        text = leer(text);
                        text += "Programmgruppe: " + gruppe.arr[Konstanten.PROGRAMMGRUPPE_NAME_NR] + "\n";
                        text = leer(text);
                        text += prog.arr[Konstanten.PROGRAMM_NAME_NR].equals("") ? "" : "Programmname: " + prog.arr[Konstanten.PROGRAMM_NAME_NR] + "\n";
                        text = leer(text);
                        text += "Pfad: " + prog.arr[Konstanten.PROGRAMM_PROGRAMMPFAD_NR] + "\n";
                        if (!prog.arr[Konstanten.PROGRAMM_PROGRAMMPFAD_NR].contains("/")
                                && !prog.arr[Konstanten.PROGRAMM_PROGRAMMPFAD_NR].contains("\\")) {
                            text = leer(text);
                            text += "===============================" + "\n";
                            text = leer(text);
                            text += "Wenn das Programm nicht im Systempfad liegt, " + "\n";
                            text = leer(text);
                            text += "wird der Start nicht klappen!" + "\n" + "\n" + "\n";
                        } else {
                            text += "\n" + "\n";
                        }
                    } else {
                        //sollte alles passen
                        text += "Ok!" + "\n";
                        text = leer(text);
                        text += "Programmgruppe: " + gruppe.arr[Konstanten.PROGRAMMGRUPPE_NAME_NR] + "\n";
                        text = leer(text);
                        text += prog.arr[Konstanten.PROGRAMM_NAME_NR].equals("") ? "" : "Programmname: " + prog.arr[Konstanten.PROGRAMM_NAME_NR] + "\n";
                        text = leer(text);
                        text += "Pfad: " + prog.arr[Konstanten.PROGRAMM_PROGRAMMPFAD_NR] + "\n" + "\n" + "\n";
                    }
                }
            }
        }
        new DialogHilfe(null, true, text).setVisible(true);
        return ret;
    }

    private static String leer(String text) {
        return text += "     ";
    }

    public static String getJetzt_ddMMyyyy_HHmm() {
        Date today;
        String output;
        SimpleDateFormat formatter;
        formatter = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
        today = new Date();
        output = formatter.format(today);
        return output;
    }

    public static String getJetzt_HH_MM_SS() {
        Date today;
        String output;
        SimpleDateFormat formatter;
        formatter = new SimpleDateFormat("HH:mm:ss");
        today = new Date();
        output = formatter.format(today);
        return output;
    }

    public static String getJetzt_HHMMSS() {
        Date today;
        String output;
        SimpleDateFormat formatter;
        formatter = new SimpleDateFormat("HHmmss");
        today = new Date();
        output = formatter.format(today);
        return output;
    }

    public static String getHeute_yyyyMMdd() {
        Date today;
        String output;
        SimpleDateFormat formatter;
        formatter = new SimpleDateFormat("yyyyMMdd");
        today = new Date();
        output = formatter.format(today);
        return output;
    }

    public static String getHeute_dd_MM_yyyy() {
        Date today;
        String output;
        SimpleDateFormat formatter;
        formatter = new SimpleDateFormat("dd.MM.yyyy");
        today = new Date();
        output = formatter.format(today);
        return output;
    }

    public static String getStandardUserAgent() {
        return Konstanten.USER_AGENT_DEFAULT + " " + Konstanten.VERSION;
    }

    public static String[] addLeerListe(String[] str) {
        //ein Leerzeichen der Liste voranstellen
        int len = str.length + 1;
        String[] liste = new String[len];
        liste[0] = "";
        for (int i = 1; i < len; ++i) {
            liste[i] = str[i - 1];
        }
        return liste;
    }

    public static boolean praefixTesten(String str, String uurl, boolean praefix) {
        //prüfen ob url beginnt/endet mit einem Argument in str
        //wenn str leer dann true
        boolean ret = false;
        String url = uurl.toLowerCase();
        String s1 = "";
        if (str.equals("")) {
            ret = true;
        } else {
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) != ',') {
                    s1 += str.charAt(i);
                }
                if (str.charAt(i) == ',' || i >= str.length() - 1) {
                    if (praefix) {
                        //Präfix prüfen
                        if (url.startsWith(s1.toLowerCase())) {
                            ret = true;
                            break;
                        }
                    } else {
                        //Suffix prüfen
                        if (url.endsWith(s1.toLowerCase())) {
                            ret = true;
                            break;
                        }
                    }
                    s1 = "";
                }
            }
        }
        return ret;
    }

    public static void spaltenFilmSetzen(JTable tabelle, Daten daten, boolean abo, boolean ziel, boolean prog) {
        //abo anzeigen
        //ziel Downloadziel anzeigen
        //prog passendes Programm anzeigen
        if (daten.debug) {
            for (int i = 0; i < tabelle.getColumnCount(); ++i) {
                if (i == Konstanten.FILM_NR_NR
                        || i == Konstanten.FILM_SENDER_NR) {
                    tabelle.getColumnModel().getColumn(i).setMinWidth(10);
                    tabelle.getColumnModel().getColumn(i).setMaxWidth(3000);
                    tabelle.getColumnModel().getColumn(i).setPreferredWidth(100);
                } else if (i == Konstanten.FILM_TITEL_NR
                        || i == Konstanten.FILM_URL_NR) {
                    tabelle.getColumnModel().getColumn(i).setMinWidth(10);
                    tabelle.getColumnModel().getColumn(i).setMaxWidth(3000);
                    tabelle.getColumnModel().getColumn(i).setPreferredWidth(300);
                } else {
                    tabelle.getColumnModel().getColumn(i).setMinWidth(10);
                    tabelle.getColumnModel().getColumn(i).setMaxWidth(3000);
                    tabelle.getColumnModel().getColumn(i).setPreferredWidth(200);
                }
            }
        } else {
            for (int i = 0; i < tabelle.getColumnCount(); ++i) {
                if (!ziel && i == Konstanten.FILM_ZIEL_PFAD_NR
                        || i == Konstanten.FILM_ZIEL_DATEI_NR
                        || i == Konstanten.FILM_ZIEL_PFAD_DATEI_NR) {
                    tabelle.getColumnModel().getColumn(i).setMinWidth(0);
                    tabelle.getColumnModel().getColumn(i).setPreferredWidth(0);
                    tabelle.getColumnModel().getColumn(i).setMaxWidth(0);
                } else if (!prog && (i == Konstanten.FILM_PROG_NR)) {
                    tabelle.getColumnModel().getColumn(i).setMinWidth(0);
                    tabelle.getColumnModel().getColumn(i).setPreferredWidth(0);
                    tabelle.getColumnModel().getColumn(i).setMaxWidth(0);
                } else if (i == Konstanten.FILM_URL_ORG_NR
                        || i == Konstanten.FILM_URL_RTMP_NR
                        //                        || i == Konstanten.FILM_URL_HD_NR
                        || i == Konstanten.FILM_URL_AUTH_NR
                        || i == Konstanten.FILM_ALT_NR
                        || i == Konstanten.FILM_URL_THEMA_NR) {
                    tabelle.getColumnModel().getColumn(i).setMinWidth(0);
                    tabelle.getColumnModel().getColumn(i).setPreferredWidth(0);
                    tabelle.getColumnModel().getColumn(i).setMaxWidth(0);
                } else if (i == Konstanten.FILME_MAX_ELEM) {
                    if (!abo) {
                        tabelle.getColumnModel().getColumn(i).setMinWidth(0);
                        tabelle.getColumnModel().getColumn(i).setMaxWidth(0);
                        tabelle.getColumnModel().getColumn(i).setPreferredWidth(0);
                    } else {
                        tabelle.getColumnModel().getColumn(i).setMinWidth(100);
                        tabelle.getColumnModel().getColumn(i).setMaxWidth(3000);
                        tabelle.getColumnModel().getColumn(i).setPreferredWidth(100);
                    }
                } else if (i == Konstanten.FILM_NR_NR
                        || i == Konstanten.FILM_SENDER_NR) {
                    tabelle.getColumnModel().getColumn(i).setMinWidth(10);
                    tabelle.getColumnModel().getColumn(i).setMaxWidth(3000);
                    tabelle.getColumnModel().getColumn(i).setPreferredWidth(100);
                } else if (i == Konstanten.FILM_TITEL_NR
                        || i == Konstanten.FILM_URL_NR) {
                    tabelle.getColumnModel().getColumn(i).setMinWidth(10);
                    tabelle.getColumnModel().getColumn(i).setMaxWidth(3000);
                    tabelle.getColumnModel().getColumn(i).setPreferredWidth(300);
                } else {
                    tabelle.getColumnModel().getColumn(i).setMinWidth(10);
                    tabelle.getColumnModel().getColumn(i).setMaxWidth(3000);
                    tabelle.getColumnModel().getColumn(i).setPreferredWidth(200);
                }
            }
        }
    }

    public static boolean urlExists(String URL) {
        java.net.URL url;
        try {
            url = new URL(URL);
        } catch (MalformedURLException e) {
            return false;
        }
        try {
            url.openStream().close();
            return true;
        } catch (IOException e) {
//            daten.fehler.systemMeldung(e.getMessage());
            return false;
        }
    }

    public static String getBefhelsString(String befehl, String zielDateiname, String url, DatenFilm datenFilm) {
        String befehlsString = befehl;
        befehlsString = befehlsString.replace("**", zielDateiname);
        befehlsString = befehlsString.replace("%f", url);
        //Auth eintragen
        if (datenFilm.arr[Konstanten.FILM_URL_AUTH_NR].equals("")) {
            befehlsString = befehlsString.replace("%a", "");
            befehlsString = befehlsString.replace("%A", "");
        } else {
            befehlsString = befehlsString.replace("%a", datenFilm.arr[Konstanten.FILM_URL_AUTH_NR]);
            befehlsString = befehlsString.replace("%A", "-W " + datenFilm.arr[Konstanten.FILM_URL_AUTH_NR]);
        }
        return befehlsString;
    }

    public static String textLaenge(String text) {
        if (text.length() != 80) {
            return textLaenge(80, text);
        } else {
            return text;
        }
    }

    public static String textLaenge(int max, String text) {
        final int MAX = max;
        if (text.length() > MAX) {
            //text = text.substring(0, MAX);
            text = text.substring(0, 25) + " .... " + text.substring(text.length() - (MAX - 31));
        }
        while (text.length() < MAX) {
            text = text + " ";
        }
        return text;
    }

    public static int getUpdateFilme(Daten d) {
        int ret = 0;
        try {
            ret = Integer.parseInt(d.system[Konstanten.SYSTEM_UPDATE_FILME_NR]);
        } catch (Exception ex) {
            ret = 0;
        }
        return ret;
    }

    public static String convertDatum(Daten daten, String datum) {
        //<pubDate>Mon, 03 Jan 2011 17:06:16 +0100</pubDate>
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
            Date filmDate = sdfIn.parse(datum);
            SimpleDateFormat sdfOut;
            sdfOut = new SimpleDateFormat("dd.MM.yyyy");
            datum = sdfOut.format(filmDate);
        } catch (Exception ex) {
            daten.fehler.fehlerMeldung(ex, "Mediathek3Sat.convertDatum");
        }
        return datum;
    }

    public static String convertTime(Daten daten, String datum) {
        //<pubDate>Mon, 03 Jan 2011 17:06:16 +0100</pubDate>
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
            Date filmDate = sdfIn.parse(datum);
            SimpleDateFormat sdfOut;
            sdfOut = new SimpleDateFormat("HH:mm:ss");
            datum = sdfOut.format(filmDate);
        } catch (Exception ex) {
            daten.fehler.fehlerMeldung(ex, "Mediathek3Sat.convertDatum");
        }
        return datum;
    }

    public static String checkDatum(Daten daten, String datum, String text) {
        String ret = datum.trim();
        if (!ret.equals("")) {
            if (!ret.contains(".")) {
                ret = "";
            }
            if (ret.length() != 10) {
                ret = "";
            }
            if (ret.equals("")) {
                daten.fehler.fehlerMeldung("Fehler: ", "DatenFilm.CheckDatum: " + datum + " " + text);
            }
        }
        return ret;
    }

    public static String checkZeit(Daten daten, String zeit, String text) {
        String ret = zeit.trim();
        if (!ret.equals("")) {
            if (!ret.contains(":")) {
                ret = "";
            }
            if (ret.length() != 8) {
                ret = "";
            }
            if (ret.equals("")) {
                daten.fehler.fehlerMeldung("Fehler: ", "DatenFilm.CheckZeit: " + zeit + " " + text);
            }
        }
        return ret;
    }

    public static String datumDrehen(String datum) {
        String ret = "";
        if (!datum.equals("")) {
            try {
                if (datum.length() == 10) {
                    String tmp = datum.substring(6); // Jahr
                    tmp += "." + datum.substring(3, 5); // Monat
                    tmp += "." + datum.substring(0, 2); // Tag
                    ret = tmp;
                }
            } catch (Exception ex) {
            }

        }
        return ret;
    }

    public static String datumDatumZeitReinigen(String datum) {
        String ret = "";
        ret = datum;
        ret = ret.replace(":", "");
        ret = ret.replace(".", "");
        return ret;
    }
}
