<?php
// This script shows movies that are borrowed, available, reserved or overdue.

// Display what movies are currently borrowed
if ($_GET['loc'] == "out") {
   $sql = "SELECT movie_id, movie_title, borrower_uid, date_due_back, 
      reserved_uid, movie_format FROM movies_list WHERE borrower_uid != '' 
      ORDER BY movie_title";
   $result = $mm->dbExec($sql);
   if ($mm->dbCountRows($result)) {
      $num_results = $mm->dbCountRows($result);
      echo "<p class=\"subheading\">{$module_text['borrowedmovies']}</p>";
      echo "<p class=\"mainext\">$num_results ";
      echo "{$module_text['resultsshown']}\n</p>\n";
?>

<table class="main" border="1" cellpadding="3">
   <tr>
      <td align="center">
         <p class="mainlabel"><?php echo $module_text['movietitle'];?></p>
      </td>
      <td align="center">
         <p class="mainlabel"><?php echo $module_text['media'];?></p>
      </td>
<?php
// The viewer must be level 2 or 3 to view who's borrowed movies
      if ($_SESSION['level'] > '1') {
?>

      <td align="center">
         <p class="mainlabel"><?php echo $module_text['borrowedby'];?></p>
      </td>

<?php 
      }; 
?>

      <td align="center">
         <p class="mainlabel"><?php echo $module_text['dueback'];?></p>
      </td>
   </tr>

<?php
      while ($row = $mm->dbFetchArray($result)) {
         list($movie_id, $movie_title, $borrower_uid, $date_due_back, 
            $reserved_uid, $movie_format) = $row;
         $movie_title = stripslashes($movie_title);
         echo "<tr>\n<td>\n<p class='maintext'>";
         echo "<a href=\"index.php?module=movies&do=details";
         echo "&id=$movie_id\">$movie_title</a>\n</p></td>";
         echo "<td><p class='maintext'>$movie_format</p></td>";
         
         $sql = "SELECT user_name, real_name FROM global_users 
            WHERE user_id = '$borrower_uid'";
         $result2 = $mm->dbExec($sql);
         list($user_name, $real_name) = $mm->dbFetchRow($result2);
            
         if ($_SESSION['level'] > '0') {
            echo "<td><p class='maintext'>";
            echo "<a href='details.php?id=$borrower_uid'>";
            echo "$real_name</a> ($user_name)";
            echo "</p></td>";
         };
         // Make the due date readable
         $due_back = date("l, j M Y", $date_due_back);

         // If it's overdue, show the date in red
         if ($date_due_back < date("U")) {
            echo "<td><p class=\"maintext\"";
            echo "style=\"color:#ff0000;font-weight:bold\">";
            echo "$due_back";
            echo "</p></td></tr>";
         } else {
            echo "<td><p class=\"maintext\">";
            echo "$due_back";
            echo "</p></td></tr>";
         };
      };
?>

</table>

<?php
   } else { 
      echo $module_text['nothingborrowed'];
   };
               
// Display what movies are available
} elseif ($_GET['loc'] == "in") {
   $sql = "SELECT movie_id, movie_title, reserved_uid, movie_format 
      FROM movies_list WHERE borrower_uid = '' ORDER BY movie_title";
   $result = $mm->dbExec($sql);

   if ($mm->dbCountRows($result)) {
      $num_results = $mm->dbCountRows($result);
      echo "<p class=\"subheading\">{$module_text['availablemovies']}</p>\n\n";
      echo "<p class=\"maintext\">$num_results ";
      echo "{$module_text['resultsshown']}\n</p>\n";
?>

<table class="main" border="1" cellpadding="3">
   <tr>
      <td align="center">
         <p class="mainlabel"><?php echo $module_text['movietitle'];?></p>
      </td>
      <td align="center">
         <p class="mainlabel"><?php echo $module_text['media'];?></p>
      </td>
      <td align="center">
         <p class="mainlabel"><?php echo $module_text['reserved'];?></p>
      </td>
   </tr>

<?php
      while ($row = $mm->dbFetchArray($result)) {
         list($movie_id, $movie_title, $reserved_uid, $movie_format) = $row;
         //$ab_title = substr("$movie_title", 0, 1);
         $movie_title = stripslashes($movie_title);
         echo "\n<tr><td><p class='maintext'>";
         echo "<a name='$movie_title' href='index.php?module=movies&";
         echo "do=details&id=$movie_id'>$movie_title</a></p></td>";
         echo "<td><p class='maintext'>$movie_format</p></td>";
         
         echo "<td align=\"center\">";
         // If the movie is reserved, show a graphic.
         if ($reserved_uid) {
?>

            <img src="modules/movies/gfx/reserved.png" width="20" height="20" 
               border="0" alt="<?php echo $module_text['reserved'];?>">

<?php
         };
         echo "</td></tr>";
      };
?>

</table>

<?php
   } else { 
      echo $module_text['nomovies'];;
   };
// Display reserved movies
} elseif ($_GET['loc'] == "res") {
   $sql = "SELECT movie_id, movie_title, borrower_uid, reserved_uid,
      movie_format FROM movies_list WHERE reserved_uid !='' ORDER BY
      movie_title";
   $result = $mm->dbExec($sql);
   if ($mm->dbCountRows($result)) {
      $num_results = $mm->dbCountRows($result);
      echo "<p class=\"subheading\">Reserved movies</p>\n\n";
      echo "<p class=\"maintext\">$num_results results shown.\n</p>\n";
?>

<table class="main" border="1" cellpadding="3">
   <tr>
      <td align="center">
         <p class="mainlabel"><?php echo $module_text['movietitle'];?></p>
      </td>
      <td align="center">
         <p class="mainlabel"><?php echo $module_text['media'];?></p>
      </td>
      
<?php
      // The viewer must be level 2 or 3 to see who's reserved movies
      if ($_SESSION['level'] > '1') {
?>

      <td align="center">
         <p class="mainlabel"><?php echo $module_text['reservedfor'];?></p>
      </td>

<?php 
      }; 
?>

      <td>
         <p class="mainlabel"><?php echo $module_text['Available'];?></p>
      </td>
   </tr>

<?php
      while ($row = $mm->dbFetchArray($result)) {
         list($movie_id, $movie_title, $borrower_uid, $reserved_uid,
            $movie_format) = $row;
         $movie_title = stripslashes($movie_title);
         echo "\n<tr><td><p class='maintext'>";
         echo "<a href='index.php?module=movies&do=details&";
         echo "id=$movie_id'>$movie_title</a></p></td>";
         echo "<td><p class='maintext'>$movie_format</p></td>";

         $sql = "SELECT user_name, real_name FROM global_users 
            WHERE user_id = '$reserved_uid'";
         $result2 = $mm->dbExec($sql);
         list($user_name, $real_name) = $mm->dbFetchRow($result2);

         // If the viewer is logged in, then show them more info
         if ($_SESSION['level'] > '1') {
            echo "<td><p class=\"maintext\"><a href=\"details.php";
            echo "?id=$reserved_uid\">$real_name</a> ($user_name)</p></td>";
         };

         // If the movie is available, show a tick.  otherwise show a cross.
         if (!$borrower_uid) {
?>

<td align="center"><img src="modules/movies/gfx/tick.png" width="20" height="20" border="0" alt="<?php echo $module_text['yes'];?>"></td></tr>

<?php
         } else {
?>

<td align="center"><img src="modules/movies/gfx/cross.png"  width="20" height="20" border="0" alt="<?php echo $module_text['no'];?>"></td></tr>

<?php
         };

      }; // End of while loop to display reserved movies
?>

</table>

<?php

   } else {
      echo $module_text['nothingreserved'];
   };
// Display overdue movies
} elseif ($_GET['loc'] == "over") {
                  
   // A quick credentials check... we can't have just anyone seeing 
   // who doesn't return their movies on time.  :)
   if ($_SESSION['level'] > '1') {

      $sql = "SELECT movie_id, movie_title, borrower_uid, date_due_back,
         movie_format FROM movies_list WHERE borrower_uid != ''";
      $result = $mm->dbExec($sql);
      // Check to see if we have any overdue
      $overdue_movies = "0";
      while ($row = $mm->dbFetchArray($result)) {
         list($movie_id, $movie_title, $borrower_uid, $date_due_back,
            $movie_format) = $row;
         if ($date_due_back < date("U")) {
            $overdue_movies ++;
         };
      };
                     
      // If there are no movies overdue, then show a message saying so
      if ($overdue_movies == '0') {
         echo $module_text['noneoverdue'];
                     
      // Otherwise, let's show them the overdue movies already!
      } else {
         $num_results = $mm->dbCountRows($result);
         echo "<p class=\"subheading\">{$module_text['overduemovies']}</p>";
         echo "<p class=\"maintext\">$num_results ";
         echo "{$module_text['resultsshown']}</p>";
?>

<table class="main" border="1" cellpadding="3">
   <tr>
      <td align="center">
         <p class="mainlabel"><?php echo $module_text['movietitle'];?></p>
      </td>
      <td align="center">
         <p class="mainlabel"><?php echo $module_text['media'];?></p>
      </td>
      <td align="center">
         <p class="mainlabel"><?php echo $module_text['borrowedby'];?></p>
      </td>
      <td align="center">
         <p class="mainlabel"><?php echo $module_text['dueback'];?></p>
      </td>
      <td align="center">
         <p class="mainlabel"><?php echo $module_text['daysoverdue'];?></p>
      </td>
   </tr>

<?php
         $sql = "SELECT movie_id, movie_title, borrower_uid,
            date_due_back, movie_format FROM movies_list WHERE
            borrower_uid != '' ORDER BY movie_title";
         $result = $mm->dbExec($sql);
         while ($row = $mm->dbFetchArray($result)) {
            list($movie_id, $movie_title, $borrower_uid, $date_due_back,
               $movie_format) = $row;
            $movie_title = stripslashes($movie_title);
            if ($date_due_back < date("U")) {
               $due_back = date("l, j M Y", $date_due_back);
?>

   <tr>
      <td>
         <p class="maintext">

<?php 
               echo "<a href=\"index.php?module=movies&do=details&";
               echo "id=$movie_id\">$movie_title</a>";
?>

         </p>
      </td>
      <td>
         <p class="maintext"><? echo "$movie_format"; ?>
      </td>
      <td>
         <p class="maintext">

<?php 
               $sql = "SELECT real_name FROM global_users 
                  WHERE user_id = '$borrower_uid'";
               $result2 = $mm->dbExec($sql);
               list($real_name) = $mm->dbFetchRow($result2);
               echo "<a href=\"details.php?id=$borrower_uid\">$real_name</a>";
?>

         </p>
      </td>
      <td>
         <p class="maintext" style="color:#ff0000;font-weight:bold">

<?php echo "$due_back";?>

         </p>
      </td>
      <td align="center">
         <p class="maintext">

<?php
               echo round((strtotime("now") - $date_due_back)/86400,0);
?>

         </p>
      </td>
   </tr>

<?php
            }; // End of overdue check and display

         }; // End of while loop for overdue check 
?>

</table>

<?php
      }; // End of showing overdue movies
   // If the user hasn't got the right admin level
   } else {
?>

<table class="main">
   <tr>
      <td>

<?php echo $global_text['nopermission'];?>

      </td>
   </tr>
</table>

<?php
   }; // End of credentials check
}; // End of locations
?>

