/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>

#include <string.h>
#include <stdlib.h>

med_err 
MEDprofilLire(med_idt fid,med_int *pflval, char *profilname)
{
  med_err ret = -1;
  med_idt gid=0;
  char chemin[MED_TAILLE_PROFILS+MED_TAILLE_NOM+1]=""; 

  /*
   * On inhibe le gestionnaire d'erreur HDF 5
   */
  _MEDmodeErreurVerrouiller();

  /* 
   * ouverture du groupe /PROFILS/"nom"
   */  
  strcpy(chemin,MED_PROFILS);
  strcat(chemin,profilname); 
  if ((gid = _MEDdatagroupOuvrir(fid,chemin)) < 0) {
    MESSAGE("Impossible d'ouvrir le datagroup : ");
    SSCRUTE(chemin); goto ERROR;
  }

  /*
   * Lecture du profil
   */
#if defined(HAVE_F77INT64)
  if ( _MEDdatasetNumLire(gid,MED_NOM_PFL,MED_INT64,
				 MED_NO_INTERLACE,1,MED_ALL,
				 MED_NOPF,MED_NO_PFLMOD,MED_PFL_NON_COMPACT,0,MED_NOPG,0,
				 (unsigned char *) pflval) < 0) {
    MESSAGE("Impossible de lire le dataset : ");
    SSCRUTE(MED_NOM_PFL); goto ERROR;
  }
#else
  if ( _MEDdatasetNumLire(gid,MED_NOM_PFL,MED_INT32,
				 MED_NO_INTERLACE,1,MED_ALL,
				 MED_NOPF,MED_NO_PFLMOD,MED_PFL_NON_COMPACT,0,MED_NOPG,0,
				 (unsigned char *) pflval) < 0) {
    MESSAGE("Impossible de lire le dataset : ");
    SSCRUTE(MED_NOM_PFL); goto ERROR;
  }

#endif

  /*
   * On ferme tout
   */

  ret = 0;
 ERROR:

  if ( gid > 0 ) if ( _MEDdatagroupFermer(gid) < 0) {
    MESSAGE("Impossible de fermer le datagroup : ");
    ISCRUTE_id(gid); ret = -1; 
  }

  return ret;
}
