/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h> 

#ifdef PPRO_NT
#define F_OK 0
#else
#include <unistd.h>
#endif

/* Variable globale qui gere le mode d'acces aux fichiers */
/* ATTENTION : si on ouvre plusieurs fichiers, il faut les
   ouvri tous avec le meme mode d'acces */
med_mode_acces MED_MODE_ACCES;


med_idt
MEDouvrir(char *nom, med_mode_acces mode_acces)
{
  med_idt fid; 

  /*
   * On inhibe le gestionnaire d'erreur HDF
   */
  _MEDmodeErreurVerrouiller();

  /*
   * On ouvre le fichier MED sous HDF
   */
  switch(mode_acces)
    {
    case MED_LECTURE :
      if (access(nom,F_OK)) {

	MESSAGE("Impossible d'accder aux fichier :");
	SSCRUTE(nom);
	return -1;
	
      } else { 
	if ((fid = _MEDfichierOuvrir(nom,mode_acces)) < 0)  return -1;
	/*_MEDsetModeAcces(fid,MED_LECTURE);*/
      };
      break;

    case MED_LECTURE_ECRITURE : 
      if (access(nom,F_OK)) {
	  if ((fid = _MEDfichierCreer(nom,mode_acces)) < 0)
	    return -1;
      } else 
	if ((fid = _MEDfichierOuvrir(nom,mode_acces)) < 0)
	  return -1;
      break;

    case MED_LECTURE_AJOUT    :
      if (access(nom,F_OK))
	{
	  if ((fid = _MEDfichierCreer(nom,mode_acces)) < 0)
	    return -1;
	}
      else 
	if ((fid = _MEDfichierOuvrir(nom,mode_acces)) < 0)
	  return -1;
      break;
      
    case MED_CREATION :
      if ((fid = _MEDfichierCreer(nom,MED_LECTURE_ECRITURE)) < 0)
	return -1;
      break;

    default :
      return -1;
    }

  return fid;
}
