/*************************************************************************
* COPYRIGHT (C) 1999 - 2007  EDF R&D, CEA/DEN
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

#include <med.h>
#include <med_config.h>
#include <med_outils.h>

#include <string.h>
#include <stdlib.h>

med_int 
MEDnGroupe(med_idt fid,char *maa, int indice)
{
  med_idt datagroup,famid;
  med_err ret;
  char chemin[MED_TAILLE_MAA+MED_TAILLE_FAS+MED_TAILLE_FAS_ENTITE+2*MED_TAILLE_NOM+1];
  char stockage[MED_TAILLE_MAA+MED_TAILLE_FAS+MED_TAILLE_FAS_ENTITE+2*MED_TAILLE_NOM+1];
  med_int n;
  int n_tmp;
  int num;
  char famille[MED_TAILLE_NOM+1];
  int nfamnoe,nfammai;

  /* 
   * On inhibe le gestionnaire d'erreur HDF 
   */
  _MEDmodeErreurVerrouiller();

  strcpy(chemin,MED_MAA);
  strcat(chemin,maa);
  strcat(chemin,MED_FAS);

  num = indice - 1;
  
  /* Acces a la famille :
   * nfam = nfamnoe + 1 + nfammai
   * Repartition selon l'indice "num" dans le datagroup :
   *    - 0..nfammai - 1 : familles des mailles/faces/aretes
   *    - nfamai : famille 0
   *    - (nfamai + 1)..(nfammai+nfamnoe) : familles de noeuds 
   */

  /* On va compter les familles de mailles/faces/aretes */
  strcpy(stockage,chemin);
  strcat(stockage,MED_FAS_ELEME_NOM);
  nfammai = 0;
  n_tmp = 0;
  if ((ret =_MEDnObjets(fid,stockage,&n_tmp)) == 0) 
    nfammai = (med_int ) n_tmp;
  strcat(stockage,"/");
  
  /* Pour la famille 0 */
  if (num == nfammai) 
    return 0;

  if (num > nfammai) {
    /* C'est une famille de noeuds */
    strcpy(stockage,chemin);
    strcat(stockage,MED_FAS_NOEUD_NOM);
    strcat(stockage,"/");
    num = num - nfammai - 1;
  }
      
  /* 
   * Si le Data Group de la famille n'existe pas => erreur
   */
  if ((ret = _MEDobjetIdentifier(fid,stockage,num,
				 famille)) < 0)
    return -1;
  strcat(stockage,famille);
  
  if ((famid = _MEDdatagroupOuvrir(fid,stockage)) < 0)
    return -1;
  
  if ((datagroup = _MEDdatagroupOuvrir(famid,MED_NOM_GRO)) < 0)
    n = 0;
  else
    {
      if ((ret = _MEDattrEntierLire(datagroup,MED_NOM_NBR,&n)) < 0)
	return -1;
      if ((ret = _MEDdatagroupFermer(datagroup)) < 0)
	return -1;
    }

  if ((ret = _MEDdatagroupFermer(famid)) < 0)
    return -1;

  return (med_int) n;
}
