
/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

/******************************************************************************
 * - Nom du fichier : test31.c
 *
 * - Description : ecriture d'une numerotation globale dans un maillage MED 
 *
 *****************************************************************************/

#include <med.h>
#include <med_utils.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int main (int argc, char **argv)
{
  med_err ret = 0;
  med_idt fid;
  /* la dimension du maillage */
  med_int mdim;
  /* nom du maillage de longueur maxi MED_TAILLE_NOM */
  char maa[MED_TAILLE_NOM+1];
  /* le nombre de noeuds */
  med_int nnoe = 0;
  /* table des numeros global */
  med_int *numglobalnoe;

  /* variable de stockage pour reperer le maillage */
  med_int i;
  char desc[MED_TAILLE_DESC+1];
  med_maillage type;



  if (argc != 2) {
    MESSAGE("Il faut passer un fichier MED en paramtre");
    return -1;
  }

  /* Ouverture du fichier passe en argument en lecture seule */
  if ((fid = MEDouvrir(argv[1],MED_LECTURE_ECRITURE)) < 0) {
    MESSAGE("Erreur a l'ouverture du fichier : "); SSCRUTE(argv[1]);
    return -1;
  }
  

  /* Lecture des infos concernant le premier maillage */
  if (MEDmaaInfo(fid,1,maa,&mdim,&type,desc) < 0) {
    MESSAGE("Erreur a la lecture des informations du 1er maillage");
    return -1;
  }
  printf("Maillage de nom : %s et de dimension : %d \n",maa,mdim);

  /* Lecture du nombre de noeuds */
  if ((nnoe = MEDnEntMaa(fid,maa,MED_COOR,MED_NOEUD,0,0)) < 0) {
    MESSAGE("Erreur a la lecture du nombre de noeuds ");
    return -1;
  }
  printf("Nombre de noeuds : %d \n",nnoe);

  /* Allocations memoires */

  /* table de la numerotation globale
     profil : (nombre de noeuds ) */
  if (nnoe > 0) {
    numglobalnoe = (med_int*) malloc(sizeof(med_int)*nnoe);
    for (i=0;i<nnoe;i++) {
      numglobalnoe[i]=i+100;
    }
  }

  /* ecriture de la numerotation globale */
  
  if (MEDglobalNumEcr(fid,maa,numglobalnoe,nnoe,MED_NOEUD,0)<0) {
    MESSAGE("Erreur a l''ecriture de la numerotation globale");
    return -1;
  }

  free(numglobalnoe);

  /* Fermeture du fichier */
  if (MEDfermer(fid) < 0) {
    MESSAGE("Erreur a la fermeture du fichier");
    return -1;
  }

  return 0;
}




