/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

/******************************************************************************
 * - Nom du fichier : test2.c
 *
 * - Description : exemples de creation de maillages MED.
 *
 *****************************************************************************/

#include <med.h>
#include <med_utils.h>

int main (int argc, char **argv)
{
  med_err ret=0;
  med_idt fid;
  char des[MED_TAILLE_DESC+1]="";

  /* Verification de la conformite du format med du fichier test1.med */
  ret = MEDformatConforme("test1.med");
  if (ret < 0) {
    MESSAGE("Format HDF non conforme ou fichier inexistant");
    return -1;
  }

  /* Ouverture en mode de lecture du fichier "test1.med" */
  fid = MEDouvrir("test1.med",MED_LECTURE);
  if (fid < 0) {
      MESSAGE("Erreur a l'ouverture du fichier test1.med en mode MED_LECTURE");
      return -1;
  }
  
  /* Affiche de l'en-tete du fichier */
  ret = MEDfichEntete(fid,MED_FICH_DES, des);
  if (ret == 0) 
    printf("En-tete du fichier test1.med : %s\n",des);
  else {
    MESSAGE("Erreur a la lecture de l'en-tete du fichier test1.med");
    ret = -1;
  }
  
  /* Fermeture du fichier test1.med */
  ret = MEDfermer(fid); 
  if (ret < 0) {
    MESSAGE("Erreur a la fermeture du fichier test1.med");
    return -1;
  }
  
  /* Ouverture en mode creation du fichier test2.med */
  fid = MEDouvrir("test2.med",MED_CREATION);
  if (fid < 0) {
    MESSAGE("Erreur a la creation du fichier test2.med");
    return -1;
  }
  
  /* Creation du maillage "maa1" de type MED_NON_STRUCTURE
     et de dimension 3 */
  if (MEDmaaCr(fid,"maa1",3,MED_NON_STRUCTURE,
		      "un premier maillage") < 0) {
    MESSAGE("Erreur a la creation du maillage maa1");
    ret = -1;
  }

  /* Ecriture du nom universel pour "maa1" */
  if (MEDunvCr(fid,"maa1") < 0) {
    MESSAGE("Erreur a la creation du nom universel de maa1");
    ret = -1;
  }

  /* Creation du maillage "maa2" de type MED_NON_STRUCTURE
     et de dimension 2 */
  if (MEDmaaCr(fid,"maa2",2,MED_NON_STRUCTURE,
		      "un second maillage") < 0) {
    MESSAGE("Erreur a la creation du maillage maa2");
    ret = -1;
  }

  /* Ecriture de la dimension de l'espace : Maillage de 
     dimension 2 dans un espace de dimension 3 */
  if (MEDdimEspaceCr(fid,"maa2",3) < 0) {
    MESSAGE("Erreur a l'ecriture de la dimension de l'espace"); 
    ret = -1; 
  }  

  /* Creation du maillage "maa3" de type MED_STRUCTURE
     et de dimension 1 */
  if (MEDmaaCr(fid,"maa3",1,MED_STRUCTURE,
		      "un troisieme maillage") < 0) {
    MESSAGE("Erreur a la creation du maillage maa3");
    ret = -1;
  }

  /* Fermeture du fichier */
  if ((ret = MEDfermer(fid))  < 0) {
    MESSAGE("Erreur a la fermeture du fichier");
    return -1;
  }
  
  return ret;
}




