/*************************************************************************
* COPYRIGHT (C) 1999 - 2003  EDF R&D
* THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
* IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
* AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
* EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
*  
* THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
* WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
* MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
* LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
*
* YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
* ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
* INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
*
*************************************************************************/

/*
 * - Nom de la fonction : MEDgaussEcr 
 * - Description : Itrateur renvoyant (npdt,nor), le nbre de point de GAUSS pour le type d'lment,
 *                 et le  maillage par dfaut avec son eventuel lien  un autre fichier. 
 * - Parametres :
 *     - fid      (IN) : ID du fichier HDF courant
 *     - indice   (IN) : itrateur (commence  1)
 *     - locname  (OUT): Nom associ  la localisation (MED_TAILLE_NOM) 
 *     - type_geo (OUT): Le type gomtrique de l'entit concern {MED_POINT,MED_SEG2 ......}
 *     - ngauss   (OUT): Nombre de points de Gauss pour l'lment de rfrence considr
 */

#include <med_outils.h>
#include <med.h>
#include <med_config.h>

#include <string.h>
#include <stdlib.h>

med_err
MEDgaussInfo(med_idt fid, int indice, char * locname, med_geometrie_element * type_geo,
	     med_int * ngauss )
{
  int numero=0;
  med_idt locid=0;
  med_err ret=-1;
  char chemin[MED_TAILLE_GAUSS+MED_TAILLE_NOM+1]="";
  med_int typegeo;

  /*
   * On inhibe le gestionnaire d'erreur
   */
  _MEDmodeErreurVerrouiller();

  /*
   * On recupere le nom du groupe de rang "indice"
   */ 
  numero = indice-1;
  if ( _MEDobjetIdentifier(fid,MED_GAUSS,numero,locname) < 0)
    goto ERROR;

  /*
   * On va chercher l'attribut ngauss 
   */
  strcpy(chemin,MED_GAUSS);
  strcat(chemin,locname);
  if ((locid = _MEDdatagroupOuvrir(fid,chemin)) < 0) {
    MESSAGE("Impossible d'ouvrir le datagroup : ");
    SSCRUTE(chemin); goto ERROR;
  }

  /* Lecture de  <ngauss> */
  if (_MEDattrEntierLire(locid,MED_NOM_NBR,ngauss) < 0) {
    MESSAGE("Erreur  la lecture de l'attribut MED_NOM_NBR : ");
    ISCRUTE(*ngauss);goto ERROR;
  };
  
  /* Lecture <type_geo> sous forme d'attribut */
  if (_MEDattrEntierLire(locid,MED_NOM_GEO,&typegeo) < 0) {
    MESSAGE("Erreur  la lecture de l'attribut MED_NOM_GEO : ");
    ISCRUTE(*type_geo);goto ERROR;
  };
  *type_geo = ( med_geometrie_element ) typegeo;

  ret = 0;

 ERROR:
  if ( locid > 0 ) if (_MEDdatagroupFermer(locid) < 0)
    goto ERROR;
  
  return 0;
}
