/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#ifndef __IO_H__
#define __IO_H__

#define _FILE_OFFSET_BITS 64

#include <glib.h>
#include <fcntl.h>
#include "string.hh"

namespace IO
{
	class Channel
	{
	private:
		GIOStatus status;
		GIOChannel* channel;

		void create(int fd);
		
	public:
		Channel(const String& filename,
			   int oflag = O_CREAT | O_RDWR,
			   mode_t mode = S_IRUSR | S_IWUSR | S_IRGRP);
		Channel(const String& filename, const gchar* mode);
		Channel(int fd);
		~Channel();
		
		int get_fd() const;
		void set_encoding(const gchar* encoding);
		GIOStatus get_status();
		gboolean is_eof();
		String read_line();
		gsize read(gchar* buffer, gsize count);
		void write(const gchar* buffer, gsize length);
		void write(const String& text);
		void write_line(const String& text);
		void write_formatted(const gchar* format, ...);
		void flush();
		String read_to_end();
	};

	class File
	{
	public:		
		static gboolean exists(const String& path);
	};

	class Directory
	{
	public:
		static gboolean exists(const String& path);
		static void create(const String& path);
	};

	class FIFO
	{
	public:
		static gboolean exists(const String& path);
		static void create(const String& path);
	};
}

#endif
