/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#ifndef __DATE_TIME_H__
#define __DATE_TIME_H__

#include "string.hh"
#include <time.h>

class DateTime
{
private:
	struct tm s;

public:
	DateTime();
	DateTime(time_t t, gboolean convert = false);
	static time_t now();
	static time_t now_utc();

	time_t get_time();

	String ftime(const String& format);
	String get_day_of_week_text();
	String get_short_day_of_week_text();
	String get_short_month_text();
	
	int get_year()			{ return 1900 + s.tm_year; }
	int get_month()			{ return s.tm_mon + 1; }
	int get_day_of_month()	{ return s.tm_mday; }
	int get_day_of_week()	{ return s.tm_wday; }
	int get_hour()			{ return s.tm_hour; }
	int get_minute()		{ return s.tm_min; }
	int get_second()		{ return s.tm_sec; }

	String to_long_string();
	String to_short_string();
	String to_time_string();
};

#endif
