""" A nested preference page for the example plugin. """


# Enthought library imports.
from enthought.envisage.ui.preference import WorkbenchPreferencePage
from enthought.traits.api import Bool
from enthought.traits.ui.api import View, Group, Item

# Local imports.
from plugin_implementation import SimpleUIPlugin


class AnotherPreferencePage(WorkbenchPreferencePage):
    """ A nested preference page for the example plugin. """

    # Should the computer explode when the application exits?
    explode_on_exit = Bool

    # The default view.
    traits_view = View(
        Group(
            Item(name='explode_on_exit'),
            show_border=False, show_left=False
        )
    )

    ###########################################################################
    # Protected 'WorkbenchPreferencePage' interface.
    ###########################################################################

    def _get_preferences(self):
        """ Returns the preferences that this page is editing. """
        
        return SimpleUIPlugin.instance.preferences

#### EOF ######################################################################
