#-------------------------------------------------------------------------------
#  
#  A factory class for creating RepositoryRoot objects for use with the  
#  Repository class based on a class and relative path from the class's
#  location.
#  
#  Written by: David C. Morrill
#  
#  Date: 03/31/2006
#  
#  (c) Copyright 2006 by Enthought, Inc.
#  
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
#  Imports:  
#-------------------------------------------------------------------------------

import sys
    
from os.path \
    import dirname, join
    
from enthought.traits.api \
    import Str
    
from repository_root \
    import RepositoryRoot
    
from repository_root_factory \
    import RepositoryRootFactory

#-------------------------------------------------------------------------------
#  'TemplateRepositoryRootFactory' class:  
#-------------------------------------------------------------------------------

class TemplateRepositoryRootFactory ( RepositoryRootFactory ):

    #---------------------------------------------------------------------------
    #  Trait definitions:  
    #---------------------------------------------------------------------------
    
    # The user name for the created RepositoryRoot:
    name = Str( 'Templates' )
    
    # The name of the class whose location will be used as the root:
    class_name = Str( 'enthought.envisage.repository.repository.Repository' )
    
    # The path (relative to the specified class) to use:
    path = Str( 'templates' )
    
    # The relative priority of RepositoryRoots created by this factory:
    priority = 100000
    
    #---------------------------------------------------------------------------
    #  'RepositoryRootFactory' interface:  
    #---------------------------------------------------------------------------
        
    def roots ( self ):
        """ Returns the list of RepositoryRoot objects this factory creates.
        """
        klass = self.plugin.import_symbol( self.class_name )
        root  = dirname( sys.modules[ klass.__module__ ].__file__ )
        path  = join( root, self.path )
        return [ RepositoryRoot( name      = self.name,
                                 path      = path,
                                 permanent = True,
                                 locked    = True,
                                 priority  = -self.priority ) ]
    
