""" Abstract base class for actions that create resources. """


# Enthought library imports.
from enthought.envisage.ui import WorkbenchAction
from enthought.naming.api import Context

class NewResourceAction(WorkbenchAction):
    """ Abstract base class for actions that create resources. """

    ###########################################################################
    # 'Action' interface.
    ###########################################################################

    def perform(self, event = None):
        """ Performs the action. """                

        raise NotImplementedError

    ###########################################################################
    # Protected 'NewResourceAction' interface.
    ###########################################################################

    def _get_default_folder(self):
        """ Returns the default folder in which to create the resource.

        Returns None if no default folder applies.

        """

        # The root of the workspace.
        from enthought.envisage import get_application
        workspace = get_application().service_registry.get_service(
                  'enthought.envisage.project.IWorkspace'
               )
        
        if len(self.window.selection) > 0:
            # Take the first item in the selection.
            binding = self.window.selection[0]
            obj     = binding.obj

            if isinstance(obj, Context)and obj is not workspace:
                default_folder = binding

            else:
                default_folder = None
                
        else:
            default_folder = None

        return default_folder

#### EOF ######################################################################
