""" A simple test plugin. """


# Enthought library imports.
from enthought.envisage import ExtensionItem, ExtensionPoint, PluginDefinition

# Plugin definition imports.
from enthought.envisage.core.core_plugin_definition import Preferences


###############################################################################
# Extension Points.
###############################################################################

class MyExtensionPoint(ExtensionPoint):
    """ A simple extension point. """

    pass

###############################################################################
# Extensions.
###############################################################################

my_contribution = MyExtensionPoint()

preferences = Preferences(
    defaults = {
        'ready_to_ship' : True,
    }
)

###############################################################################
# The plugin definition!
###############################################################################

PluginDefinition(
    # The plugin's globally unique identifier.
    id = "simple",

    # The name of the class that implements the plugin.
    class_name = "simple_plugin.SimplePlugin",

    # General information about the plugin.
    name          = "A simple test plugin",
    version       = "1.0.0",
    provider_name = "Enthought Inc",
    provider_url  = "www.enthought.com",
    enabled       = True,
    autostart     = True,

    # The Id's of the plugins that this plugin requires.
    requires = ["enthought.envisage.core"],

    # The extension points offered by this plugin.
    extension_points = [MyExtensionPoint],
    
    # The contributions that this plugin makes to extension points offered by
    # either itself or other plugins.
    extensions = [my_contribution, preferences]
)

#### EOF ######################################################################
