from setuptools import setup, find_packages

# This renames the mayavi script to a MayaVi.pyw script on win32.
from setuptools.command.install_scripts import install_scripts
class my_install_scripts(install_scripts):
    def run(self):
        import os
        install_scripts.run(self)
        if os.name != 'posix':
            # Rename <script> to <script>.pyw. Executable bits
            # are already set in install_scripts.run().
            for file in self.get_outputs():
                if file[-4:] != '.pyw':
                    if file[-7:] == 'mayavi2':
                        new_file = file[:-7] + 'MayaVi2.pyw'
                    else:
                        new_file = os.path.splitext(file)[0] + '.pyw'
                    self.announce("renaming %s to %s" % (file, new_file))
                    if not self.dry_run:
                        if os.path.exists(new_file):
                            os.remove (new_file)
                        os.rename (file, new_file)


# Function to convert simple ETS project names and versions to a requirements
# spec that works for both development builds and stable builds.  Allows
# a caller to specify a max version, which is intended to work along with
# Enthought's standard versioning scheme -- see the following write up:
#    https://svn.enthought.com/enthought/wiki/EnthoughtVersionNumbers
def etsdep(p, min, max=None, literal=False):
    require = '%s >=%s.dev' % (p, min)
    if max is not None:
        if literal is False:
            require = '%s, <%sa' % (require, max)
        else:
            require = '%s, <%s' % (require, max)
    return require


# Declare our ETS project dependencies.
ENVISAGE = etsdep('enthought.envisage', '2.0.1b1', '3.0')
LOGGER_PLUGIN = etsdep('enthought.logger[plugin]', '2.0.1b1', '3.0')    # The 'plugin' extra is required by loose-coupling in the mayavi ui plugin definition's default pespective.
PERSISTENCE = etsdep('enthought.persistence', '2.0.1b2', '3.0')
PLUGINSDEBUG = etsdep('enthought.plugins.debug', '2.0.1b1', '3.0')
PLUGINSPYTHONSHELL = etsdep('enthought.plugins.python_shell', '2.0.1b1', '3.0')
PLUGINSREFRESHCODE = etsdep('enthought.plugins.refresh_code', '2.0.1b1', '3.0')
PLUGINSTEXTEDITOR = etsdep('enthought.plugins.text_editor', '2.0.1b1', '3.0')
PYFACE_TVTK = etsdep('enthought.pyface[tvtk]', '2.0.1b1', '3.0')
TRAITS_UI = etsdep('enthought.traits[ui]', '2.0.1b1', '3.0')
TVTK_PLUGIN_WX = etsdep('enthought.tvtk[plugin, wx]', '2.0.0b2', '3.0')
UTIL = etsdep('enthought.util', '2.0.1b2', '3.0')


setup(
    author = "Prabhu Ramachandran",
    author_email = "prabhu_r@users.sf.net",
    cmdclass = {'install_scripts': my_install_scripts},
    dependency_links = [
        'http://code.enthought.com/enstaller/eggs/source',
        ],
    description = "The MayaVi scientific data visualizer",
    entry_points = {
        'console_scripts': [
            'mayavi2 = enthought.mayavi.scripts.mayavi2:main'
            ],
        },
    extras_require = {
        # All non-ets dependencies should be in this extra to ensure users can
        # decide whether to require them or not.
        'nonets': [
            "scipy >=0.5.2",
            ],
        },
    license = 'BSD',
    include_package_data = True,
    install_requires = [
        ENVISAGE,
        LOGGER_PLUGIN,
        PERSISTENCE,
        PLUGINSDEBUG,
        PLUGINSPYTHONSHELL,
        PLUGINSREFRESHCODE,
        PLUGINSTEXTEDITOR,
        PYFACE_TVTK,
        TRAITS_UI,
        TVTK_PLUGIN_WX,
        UTIL,
        ],
    name = 'enthought.mayavi',
    namespace_packages = [
        "enthought",
        ],
    packages = find_packages(),
    tests_require = [
        'nose >= 0.9',
        ],
    test_suite = 'nose.collector',
    url = 'http://code.enthought.com/mayavi2/',
    version = '2.0.2a1',
    zip_safe = False,
    )
