""" An example preference page. """


# Enthought library imports.
from enthought.envisage.ui.preference import WorkbenchPreferencePage
from enthought.traits.api import Bool, Color, Font
from enthought.traits.ui.api import View, Group, Item

# Local imports.
from plugin_implementation import SimpleUIPlugin


class ExamplePreferencePage(WorkbenchPreferencePage):
    """ An example preference page. """

    # Should the computer explode when the application exits?
    explode_on_exit = Bool

    # Should flips always be flopped?
    flip_the_flop = Bool

    # The background colour for nothing in particular.
    background_color = Color('white')

    # A font that us not used anywhere!
    label_font = Font
    
    # The default view.
    traits_view = View(
        Group(
            Item(name= 'flip_the_flop'), Item(name='explode_on_exit'),
            label='Simple', show_border=False, show_left=False,
        ),

        Group(
            Item(name='background_color'),
            Item(name='label_font'),
            label='Advanced', show_border=False, style='simple'
        )
    )

    ###########################################################################
    # Protected 'WorkbenchPreferencePage' interface.
    ###########################################################################

    def _get_preferences(self):
        """ Returns the preferences that this page is editing. """

        return SimpleUIPlugin.instance.preferences

#### EOF ######################################################################
