""" This plugin prints messages for the 'Hello World' example. """


# Enthought library imports.
from enthought.envisage.api import Plugin

# Plugin definition imports.
from enthought.envisage.examples.plugin.message.plugin_definition import \
     Message


class MessagePlugin(Plugin):
    """ Plugin that prints messages. """

    ###########################################################################
    # 'Plugin' interface.
    ###########################################################################

    def start(self, application):
        """ Starts the plugin.

        Can be called manually, but is usually called exactly once when the
        plugin is first required.

        """

        # Just for fun we toggle this 'preference' each time the plugin is
        # started. This is just to illustrate that the preferences are
        # persistent!
        if self.preferences.get('add_exclamation'):
            self.preferences.set('add_exclamation', False)
            suffix = '!'

        else:
            self.preferences.set('add_exclamation', True)
            suffix = ''

        # Get all contributions that were made to the 'Messages' extension
        # point.
        extensions = self.get_extensions(Message)
        for message in extensions:
            print message.text + suffix

        return
        
    def stop(self, application):
        """ Stops the plugin.

        Can be called manually, but is usually called exactly once when the
        application exits.

        """

        self.save_preferences()
        
        return

#### EOF ######################################################################
