""" The entry point for an Envisage application. """


# Enthought library imports.
from enthought.envisage.workbench.api import WorkbenchApplication

# Local imports.
from plugin_definitions import INCLUDE, PLUGIN_DEFINITIONS


def run():
    """ Runs the application. """

    # Create the application.
    application = WorkbenchApplication(
        id                 = 'enthought.envisage.examples.charm',
        include            = INCLUDE,
        plugin_definitions = PLUGIN_DEFINITIONS
    )

    # Run the application (this starts the application, starts the GUI event
    # loop, and when that terminates, stops the application).
    application.run()

    return


# Application entry point.
if __name__ == '__main__':
    run()

#### EOF ######################################################################
