""" Displays the preferences dialog. """


# Enthought library imports.
from enthought.envisage.workbench.action.workbench_action import \
    WorkbenchAction
from enthought.envisage.workbench.preference import PreferencePlugin
from enthought.pyface.preference.api import PreferenceDialog


class EditPreferencesAction(WorkbenchAction):
    """ Displays the preferences dialog. """

    ###########################################################################
    # 'Action' interface.
    ###########################################################################

    def perform(self):
        """ Performs the action. """

        plugin = PreferencePlugin.instance

        dialog = PreferenceDialog(
            parent = self.window.control,
            title  = 'Preferences',
            root   = plugin.root,
            style  = 'nonmodal',
            size   = (600, 400)
        )
        dialog.open()

        return

#### EOF ######################################################################
