#-----------------------------------------------------------------------------
#
#  Copyright (c) 2005-2006 by Enthought, Inc.
#  All rights reserved.
#
#  Author: David C. Morrill <dmorrill@enthought.com>
#
#-----------------------------------------------------------------------------

""" Action for saving the current perspective with a new name as a user 
    perspective.
"""

#-------------------------------------------------------------------------------
#  Imports:
#-------------------------------------------------------------------------------

from workbench_action \
    import WorkbenchAction
    
from user_perspective_name \
    import UserPerspectiveName

#-------------------------------------------------------------------------------
#  'SaveAsUserPerspectiveAction' class:
#-------------------------------------------------------------------------------    

class SaveAsUserPerspectiveAction ( WorkbenchAction ):
    """ Saves the current perspective with a new name as a user perspective.
    """
    
    #---------------------------------------------------------------------------
    #  'Action' interface:
    #---------------------------------------------------------------------------

#-- Public Interface -----------------------------------------------------------

    def perform ( self, event ):
        """ Performs the action, which is to save the current perspective with
            a new name as a user perspective.
        """
        window = event.window
        ap     = window.active_perspective
        
        # Get the new name of the user perspective:
        upn = UserPerspectiveName( name = ap.name )
        
        # If the user clicked the OK button, create the new perspective: 
        if upn.edit_traits( view = 'save_as_view' ).result:
            # Add a copy of the original perspective to replace the one we are
            # about to mutate:
            ap_copy = ap.clone_traits()
            window.perspectives.append( ap_copy )
            
            # Mutate the original perspective into a user perspective with the
            # new name:
            user_perspective = window.workbench.user_perspective
            user_perspective.add( ap, upn.name.strip() )
            
            # Update the existing menu action to refer to the clone of the
            # original perspective:
            self._manager.update( ap_copy.id, ap_copy )
            
            # Add the mutated perspective to the Perspective menu:
            self._manager.add( ap )

#### EOF #####################################################################
