""" The interactive Python shell plugin. """


# Enthought library imports.
from enthought.envisage import Plugin
from enthought.traits.api import Event, List

# Local imports.
from view.python_shell_view import PythonShellView


class PythonShellPlugin(Plugin):
    """ The interactive Python shell plugin. """

    # The shared plugin instance.
    instance = None

    #### 'PythonShellPlugin' interface ########################################

    # All views created by the plugin.
    views = List(PythonShellView)

    # fixme: Hack for demo.
    command_executed = Event
    
    ###########################################################################
    # 'object' interface.
    ###########################################################################

    def __init__(self, **kw):
        """ Creates a new plugin. """

        # Base class constructor.
        Plugin.__init__(self, **kw)

        # Set the shared instance.
        PythonShellPlugin.instance = self
        
        return

    ###########################################################################
    # 'Plugin' interface.
    ###########################################################################

    def start(self, application):
        """ Starts the plugin.

        Called exactly once when the plugin is first required.

        """

        return
    
    def stop(self, application):
        """ Stops the plugin.

        Called exactly once when either the plugin is manually stopeed or
        the application exits.

        """

        return

    ###########################################################################
    # 'PythonShell' interface.
    ###########################################################################

    def bind(self, name, value):
        """ Binds a name to a value in the interpreter's namespace. """

        for view in self.views:
            view.bind(name, value)
        
        return

    def execute_command(self, command):
        """ Execute a command in the interpreter. """
        
        for view in self.views:
            view.execute_command(command)

        return
    
#### EOF ######################################################################
