import os

def configuration(parent_package='enthought',top_path=None):
    from numpy.distutils.misc_util import Configuration
    config = Configuration('envisage',parent_package,top_path)
    config.set_options(ignore_setup_xxx_py=True,
                       assume_default_configuration=True,
                       delegate_options_to_subpackages=True,
                       quiet=True)

    for d in ['project/images',
              'project/action/images',
              'project/view/images',
              'project/wizard/images',
              'resource/images',
              'core/tests',
              'doc',
              'examples/apps',
              'project/data',
              'project/tests',
              'resource/examples',
              'resource/images',
              'single_project/images',
              'ui/images',
              'workbench/images',
              'examples/plugin/simple_ui/action/images',
              'examples/plugin/simple_ui/images',
              ]:
        config.add_data_dir(d)

    #add the parent __init__.py to allow for importing
    config.add_data_files(('..', os.path.abspath(os.path.join('..','__init__.py'))))

    config.add_data_files('single_project/*.txt')

    config.add_subpackage('*')
    config.add_subpackage('*.*')
    config.add_subpackage('*.*.*')
    config.add_subpackage('*.*.*.*')
    return config

if __name__ == "__main__":
    try:
        from numpy.distutils.core import setup
    except ImportError:
        execfile('setup_envisage.py')
    else:
        setup(version='2.1.0',
           description      = 'Envisage application framework',
           author           = 'Enthought, Inc',
           author_email     = 'info@enthought.com',
           url              = 'http://code.enthought.com/envisage',
           license          = 'BSD',
           install_requires = [ "enthought.naming", 
                                "enthought.logger", 
                                "enthought.io",
                                "enthought.help",
                                "enthought.plugins"],
           zip_safe         = False,
           configuration    = configuration)
