""" Creates a new folder. """


# Enthought library imports.
from enthought.pyface.api import GUI
from enthought.pyface.action.api import Action


class NewFolder(Action):
    """ Creates a new folder. """

    #### 'Action' interface ###################################################

    # The name of the action.
    name = 'Folder'
    
    ###########################################################################
    # 'Action' interface.
    ###########################################################################

    def perform(self, event):
        """ Performs the action. """

        parent_folder = event.node
        if parent_folder is not None:
            # Make sure the parent folder is expanded.
            event.widget.expand(parent_folder)
            
            # The context to create the folder in.
            context = parent_folder.obj

            # Generate a name that is unique within the context.
            name = self._get_unique_name('New Folder', context)

            # Create the folder.
            context.create_subcontext(name)

            # Lookup the binding.
            binding = parent_folder.obj.lookup_binding(name)

            # Start a label edit.
            GUI.invoke_later(event.widget.edit_label, *(binding,))
            
        return

    ###########################################################################
    # Private interface.
    ###########################################################################

    def _get_unique_name(self, prefix, context):
        """ Returns a name that is not already bound in a context. """

        names = context.list_names()
        name  = prefix
        
        id = 2
        while name in names:
            name = '%s (%d)' % (prefix, id)
            id += 1
            
        return name
    
#### EOF ######################################################################
