""" The resource type for Python 'None'. """


# Enthought library imports.
from enthought.envisage.resource import ObjectResourceType

# Local imports.
from none_node_type import NoneNodeType


class NoneResourceType(ObjectResourceType):
    """ The resource type for Python 'None'. """

    ###########################################################################
    # 'ResourceType' interface.
    ###########################################################################

    #### Initializers #########################################################

    def _node_type_default(self):
        """ Initializes the node type. """

        return NoneNodeType(resource_type=self)

    #### Methods ##############################################################
    
    def is_type_for(self, obj): 
        """ Returns True if the resource type 'recognizes' an object. """

        return obj is None

##### EOF #####################################################################
