#-------------------------------------------------------------------------------
#  
#  A factory class for creating RepositoryRoot objects for use with the  
#  Repository class.
#  
#  Written by: David C. Morrill
#  
#  Date: 03/30/2006
#  
#  (c) Copyright 2006 by Enthought, Inc.
#  
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
#  Imports:  
#-------------------------------------------------------------------------------

from enthought.traits.api \
    import HasPrivateTraits, Instance, Int
    
from enthought.envisage \
    import Plugin

#-------------------------------------------------------------------------------
#  'RepositoryRootFactory' class:  
#-------------------------------------------------------------------------------

class RepositoryRootFactory ( HasPrivateTraits ):

    #---------------------------------------------------------------------------
    #  Trait definitions:  
    #---------------------------------------------------------------------------
    
    # The plugin this factory is being used by:
    plugin = Instance( Plugin )
    
    # The relative priority of RepositoryRoots created by this factory:
    priority = Int
    
    #---------------------------------------------------------------------------
    #  'RepositoryRootFactory' interface:  
    #---------------------------------------------------------------------------
        
    def roots ( self ):
        """ Returns the list of RepositoryRoot objects this factory creates.
        """
        return []
    
