""" The welcome wizard. """


# Standard library imports.
from os.path import join

# Enthought library imports.
from enthought.io import File
from enthought.pyface.wizard.api import SimpleWizard, WizardPage
from enthought.traits.api import Any


class WorkspaceSelectionPage(WizardPage):
    """ A page that allows the use to select a workspace. """

    #### 'WizardPage' interface ###############################################

    # The page heading.
    heading = "Select the workspace directory - this is the directory " \
              "that is used to store your projects"

    #### 'WorkspaceLocationPage' interface ####################################

    # The object that the wizard is editing.
    #
    # fixme: This is not really an 'Any'!
    obj = Any

    ###########################################################################
    # Protected 'WizardPage' interface.
    ###########################################################################

    def _create_page_content(self, parent):
        """ Create the wizard page. """

        self.obj.on_trait_change(self._on_anytrait_changed)

        return self.obj.edit_traits(parent=parent, kind='subpanel').control

    ###########################################################################
    # Private interface.
    ###########################################################################

    def _validate(self):
        """ Set the complete state of the page. """

        ##self.complete =File(self.obj.workspace_location).is_folder
        self.complete = len(self.obj.workspace_location) > 0

        return

    #### Trait event handlers #################################################

    def _obj_changed(self):
        """ Called when the object that we are editing is changed. """

        self._validate()

        return

    def _on_anytrait_changed(self, new):
        """ Called when any trait of the workspace has been changed. """

        self._validate()

        return


def WelcomeWizard(obj):
    """ Factory function for the welcome wizard. """

    wizard = SimpleWizard(
        title = 'Workspace Launcher',
        size = (650, 175),
        pages = [
            WorkspaceSelectionPage(id='workspace_selection', obj=obj)
        ],
        show_cancel = False
    )

    return wizard

#### EOF ######################################################################
