""" Abstract base class for new resource wizards. """


# Enthought library imports.
from enthought.pyface.wizard.api import ChainedWizard
from enthought.traits.api import Instance

# Local imports.
from resource_factory import ResourceFactory


class NewResourceWizard(ChainedWizard):
    """ Abstract base class for new resource wizards. """

    #### 'Window' interface ###################################################

    # The size of the window.
    size = (400, 400)

    #### 'NewResourceWizard' interface ########################################

    # The resource factory that the wizard is configuring.
    factory = Instance(ResourceFactory, ())

    ###########################################################################
    # 'object' interface.
    ###########################################################################

    def __init__(self, **traits):
        """ Creates a new wizard. """

        # Base class constructor.
        super(NewResourceWizard, self).__init__(**traits)

        self.reset()

        return

    ###########################################################################
    # 'NewResourceWizard' interface.
    ###########################################################################

    def create_resource(self):
        """ Creates the resource. """

        # Create the resource.
        result = self.factory.create_resource()

        # Reset ourself to the initial state so we can be reused.
        del self.factory
        self.reset()

        return result

    def reset(self):
        """ Reset the wizard to the initial state. """

        raise NotImplementedError

#### EOF ######################################################################
