""" Copies the selected resources. """


# Standard library imports.
import sys

# Enthought library imports.
from enthought.envisage.ui import SelectionListenerAction
from enthought.pyface.api import error


class CopyAction(SelectionListenerAction):
    """ Copies the selected resources. """

    ###########################################################################
    # 'Action' interface.
    ###########################################################################

    def perform(self, event = None):
        """ Performs the action. """                

        # fixme: In terms of the whole UI model thang... This method would be a
        # method on the project UI service, and '_copy_nodes' would be a method
        # on the project service?!?  The scripting layer can then expose both
        # methods...
        selection = self.window.selection
        
        try:
            self._copy_nodes(selection)

        except:
            type, value, traceback = sys.exc_info()
            error(self.window.control, "Copy failed\n%s" % str(value))
            
        return

    ###########################################################################
    # 'SelectionListenerAction' interface.
    ###########################################################################

    def refresh(self):
        """ Refresh the enabled/disabled state of the action. """

        if self.window is not None and len(self.window.selection) > 0:
            for node in self.window.selection:
                # Get the resource type of the node that we are copying.
                resource_type = self.resource_manager.get_type_of(node.obj)

                # Can the node be copied?
                if not resource_type.node_type.can_copy(node):
                    self.enabled = False
                    break

            else:
                self.enabled = True

        else:
            self.enabled = False

        return

    ###########################################################################
    # Private interface.
    ###########################################################################

    def _copy_nodes(self, nodes):
        """ Copies a list of nodes. """

        application = self.window.plugin.application
        
        # fixme: Maybe a more formal clipboard!
        application.clipboard = [self._get_copy_value(node) for node in nodes]
        
        return

    def _get_copy_value(self, node):
        """ Returns the value that is actually copied for a node. """

        # Get the resource type of the node that we are copying.
        resource_type = self.resource_manager.get_type_of(node.obj)

        return resource_type.node_type.get_copy_value(node)
    
#### EOF ######################################################################
