""" A view of the application. """


# Enthought library imports.
from enthought.envisage.resource.ui import ExplorerTree
from enthought.envisage.workbench import View


class ApplicationView(View):
    """ A view of the application.

    This view is intended for developers to help in debugging etc.  It is
    NOT intended to be seen by the end user!

    """

    ###########################################################################
    # 'View' interface.
    ###########################################################################

    def create_control(self, parent):
        """ Creates the toolkit-specific control that represents the view.

        'parent' is the toolkit-specific control that is the view's parent.

        """

        return self._create_tree(parent)

    ###########################################################################
    # Private interface.
    ###########################################################################

    def _create_tree(self, parent):
        """ Creates the tree. """

        application = self.window.application

        # Create the tree!
        tree = ExplorerTree(parent, obj=application, name='Application')

        # The tree provides the view's selection.
        tree.on_trait_change(self._on_selection_changed, 'selection')

        return tree.control

    #### Trait event handlers #################################################

    def _on_selection_changed(self, obj, trait_name, old, new):
        """ Called when the selection is changed in the tree. """

        self.selection = new

        return

#### EOF ######################################################################
