""" The (optional) base class for Envisage application objects. """


# Enthought library imports.
from enthought.traits.api import HasTraits, Instance


class ApplicationObject(HasTraits):
    """ The (optional) base class for Envisage application objects. 
    
    Application objects offered by plugins may be derived from this class, but
    are not required to be. Currently, all that this class provides is access
    to the application instance. In the future, this class might offer 
    life-cycle methods or events for application objects.
    """

    #### 'ApplicationObject' interface ########################################

    # The application that the object is part of.
    application = Instance('enthought.envisage.api.Application')

#### EOF ######################################################################
