/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#include <qtextbrowser.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qhttp.h>
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>
#include "updatedialog.h"
//-----------------------------------------------------------------------------------------------------------------------
UpdateDialog::UpdateDialog(bool autoClose, bool isShown, QString curVer, QString command)
{
	setHidden(isShown);
	m_autoClose = autoClose;
	m_proc = NULL;
	m_curVer = curVer;

	if(command.isEmpty()) {
		tb_output->append(i18n("<br>Please read <b>README</b> for some simple instructions on how to configure the update.<br>"));
		pb_cancel->setText(i18n("&I will!"));
	}
	
	m_uop = new QUrlOperator("http://mtvg.sourceforge.net");
	connect(m_uop, SIGNAL(data(const QByteArray&, QNetworkOperation*)), this, SLOT(dataReceived(const QByteArray&, QNetworkOperation*)));
	connect(m_uop, SIGNAL(finished(QNetworkOperation*)), this, SLOT(netOperationFinished(QNetworkOperation*)));
	
	KConfig *cfg = KGlobal::config();
	cfg->setGroup("Version");
	cb_checkversion->setChecked(cfg->readBoolEntry("checkVersion", true));

	if(command.isEmpty()) return;

	m_proc = new KProcess;
	*m_proc << command.section(' ', 0, 0);
	for(int i=1; i<=command.contains(' ', false); i++)
		*m_proc << command.section(' ', i, i);
	connect(m_proc, SIGNAL(processExited(KProcess*)), this, SLOT(processExited(KProcess*)));
	connect(m_proc, SIGNAL(receivedStdout(KProcess*, char*, int)), this, SLOT(receivedStdout(KProcess*, char *, int)));
	connect(m_proc, SIGNAL(receivedStderr(KProcess*, char*, int)), this, SLOT(receivedStderr(KProcess*, char *, int)));
	tb_output->append("<font color=\"#0000ff\">$ " + command + "</font>");
	m_proc->start(KProcess::NotifyOnExit, KProcess::AllOutput);
}
//-----------------------------------------------------------------------------------------------------------------------
UpdateDialog::~UpdateDialog()
{
	if(m_uop) {
		delete m_uop;
		m_uop = NULL;
	}
	if(m_proc) {
		delete m_proc;
		m_proc = NULL;
	}

	KConfig *cfg = KGlobal::config();
	cfg->setGroup("Version");
	cfg->writeEntry("checkVersion", cb_checkversion->isChecked());
	cfg->sync();
}
//-----------------------------------------------------------------------------------------------------------------------
void UpdateDialog::processExited(KProcess*)
{
	if(isShown()) {
		tb_output->append("<font color=\"#0000ff\">$ # " + i18n("Process Exited.") + "</font>");
		pb_cancel->setText(i18n("&Done"));
		if(m_autoClose)
			accept();
	} else
		accept();
}
//-----------------------------------------------------------------------------------------------------------------------
void UpdateDialog::receivedStdout(KProcess*, char *buffer, int buflen)
{
	if(isShown())
		tb_output->append("<font color=\"#000000\">" + QString::fromLatin1(buffer, buflen) + "</font>");
}
//-----------------------------------------------------------------------------------------------------------------------
void UpdateDialog::receivedStderr(KProcess*, char *buffer, int buflen)
{
	if(isShown())
		tb_output->append("<font color=\"#d20000\">" + QString::fromLatin1(buffer, buflen) + "</font>");
}
//-----------------------------------------------------------------------------------------------------------------------
void UpdateDialog::cancelClicked()
{
	if(m_proc && m_proc->isRunning())
		m_proc->kill(9);
	if(m_proc) {
		delete m_proc;
		m_proc = NULL;
	}
	m_uop->stop();
	reject();
}
//-----------------------------------------------------------------------------------------------------------------------
void UpdateDialog::checkVersionClicked()
{
	if(!cb_checkversion->isChecked()) return;
	QNetworkProtocol::registerNetworkProtocol("http", new QNetworkProtocolFactory<QHttp>);

	tb_output->append("<font color=\"#000000\">MTVG: " + i18n("Checking for new MTVG-version...") + "</font>");
	m_uop->get("curver.php");
}
//-----------------------------------------------------------------------------------------------------------------------
void UpdateDialog::dataReceived(const QByteArray &data, QNetworkOperation*)
{
	m_data = data;
}
//-----------------------------------------------------------------------------------------------------------------------
void UpdateDialog::netOperationFinished(QNetworkOperation *nop)
{
	if(nop->state() != QNetworkProtocol::StDone) {
		tb_output->append("<font color=\"#000000\">MTVG: " + i18n("Couldn't receive version information.") + "</font>");
		return;
	}
	QString netVer = m_data;
	netVer = netVer.stripWhiteSpace();
	int curCmpVer = m_curVer.left(m_curVer.find('.')).toInt()*10000 + m_curVer.section('.', 1, 1).toInt()*100 + m_curVer.right(m_curVer.length()-m_curVer.findRev('.')-1).toInt();
	int netCmpVer = netVer.left(netVer.find('.')).toInt()*10000 + netVer.section('.', 1, 1).toInt()*100 + netVer.right(netVer.length()-netVer.findRev('.')-1).toInt();

	if(curCmpVer < netCmpVer) {
		tb_output->append("<font color=\"#000000\">MTVG: " + i18n("A new version (v%1) is available! Get it at <b>mtvg.sourceforge.net</b>!").arg(netVer) + "</font>");
	} else if(curCmpVer > netCmpVer) {
		tb_output->append("<font color=\"#000000\">MTVG: " + i18n("Your version is still under development.") + "</font>");
	} else {
		tb_output->append("<font color=\"#000000\">MTVG: " + i18n("You have the most recent version (v%1).").arg(m_curVer) + "</font>");
	}
}
//-----------------------------------------------------------------------------------------------------------------------
