/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#define VERSION		"7.3.2"
#define VERSION_EXT	""
//-----------------------------------------------------------------------------------------------------------------------
#include <kactioncollection.h>
#include <kapplication.h>
#include <kcolorbutton.h>
#include <kkeybutton.h>
#include <kfiledialog.h>
#include <klistview.h>
#include <kmessagebox.h>
#include <kpopupmenu.h>
#include <kconfig.h>
#include <klocale.h>
#include <kglobal.h>
#include <qlineedit.h>
#include <qwidgetstack.h>
#include <qgroupbox.h>
#include <qsplitter.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qdatetime.h>
#include <qstring.h>
#include "mainwidget.h"
#include "updatedialog.h"
#include "parsemaster.h"
#include "channelitem.h"
#include "waboutdialog.h"
#include "wnewuserdialog.h"
//-----------------------------------------------------------------------------------------------------------------------
MainWidget::MainWidget(KMainWindow *parent) : MainWgt(parent, "MainWidget"), m_prefsDialog(this), m_actionCollection(this),
	m_globalAccel(this)
{
	m_parent = parent;
	m_okToClose = false;

	m_tray = new TrayIcon(parent, this);
	m_parseMaster = new ParseMaster(this);
	m_programMaster = new ProgramMaster();
	m_favouriteMaster = new FavouriteMaster(this);
	m_blistMaster = new BlistMaster(this);
	m_programView = new ProgramView(this, m_programMaster, lv_program, m_parseMaster->programs(), Browse);
	m_searchView = new SearchView(this, m_programMaster, lv_search, m_parseMaster->programs(), Search);
	m_completeView = new CompleteView(this, m_programMaster, lv_complete, m_parseMaster->programs(), Complete);
	m_forumView = new ForumView(this, m_programMaster, 0, m_parseMaster->programs(), Forum);
	m_channelView = new ChannelView(this, lv_channel);
	m_timer = new QTimer(this);

	connect(m_timer, SIGNAL(timeout()), this, SLOT(timerDone()));
	connect(pb_quit, SIGNAL(clicked()), this, SLOT(shuttingDown()));
// TODO: Move this to a more appropriate place
	connect(lv_category, SIGNAL(selectionChanged()), this, SLOT(refresh()));

	loadSettings();
	initMain();
	newUserCheck();
}
//-----------------------------------------------------------------------------------------------------------------------
MainWidget::~MainWidget()
{
	saveSettings();

	m_timer->stop();
	delete m_tray;
	delete m_programMaster;
	delete m_favouriteMaster;
	delete m_blistMaster;
	delete m_parseMaster;
	delete m_programView;
	delete m_searchView;
	delete m_completeView;
	delete m_forumView;
	delete m_channelView;
	delete m_timer;
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::initMain()
{
	ws_main->raiseWidget(Browse);
	if(!prefs()->kkb_toggle->shortcut().isNull()) {
		m_globalAccel.insert("Toggle", "Toggle", "Toggle Mainwindow", prefs()->kkb_toggle->shortcut(), prefs()->kkb_toggle->shortcut(), m_parent, SLOT(doToggle()));
		m_globalAccel.updateConnections();
	}
	wireHotkeys();
	parse();
	rebuild();
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::loadSettings()
{
	KConfig *cfg = KGlobal::config();
	m_blockUpdate = true;

// TODO: Traverse ALL instead!	
	m_programView->loadSettings(cfg);
	m_searchView->loadSettings(cfg);
	m_completeView->loadSettings(cfg);
//	m_forumView->loadSettings(cfg);

	m_prefsDialog.loadSettings();

	cfg->setGroup("MTVG");
	splitterv->setSizes(cfg->readIntListEntry("splitterv"));
	m_detailSize = cfg->readIntListEntry("detailSize");
	d_frame->setHidden(cfg->readBoolEntry("dframeHidden", false));
	if(d_frame->isShown())
		splitterh->setSizes(cfg->readIntListEntry("splitterh"));
	splitterl->setSizes(cfg->readIntListEntry("splitterl"));
	splitterh2->setSizes(cfg->readIntListEntry("splitterh2"));

	// Search View
	// TODO: MOVE!
	cb_searchtitles->setChecked(cfg->readBoolEntry("searchTitles", true));
	cb_searchactors->setChecked(cfg->readBoolEntry("searchActors", true));
	cb_searchdesc->setChecked(cfg->readBoolEntry("searchDesc", true));

	m_favouriteMaster->loadFavourites(cfg);
	m_blistMaster->loadBlacklist(cfg);

	m_blockUpdate = false;
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::saveSettings()
{
	KConfig *cfg = KGlobal::config();

// TODO: Traverse ALL views instead!
	m_programView->saveSettings(cfg);
	m_searchView->saveSettings(cfg);
	m_completeView->saveSettings(cfg);
//	m_forumView->saveSettings(cfg);

	m_prefsDialog.saveSettings();

	cfg->setGroup("MTVG");
	// General
	cfg->writeEntry("splitterv", splitterv->sizes());
	cfg->writeEntry("splitterh", splitterh->sizes());
	cfg->writeEntry("splitterl", splitterl->sizes());
	cfg->writeEntry("splitterh2", splitterh2->sizes());
	cfg->writeEntry("dframeHidden", d_frame->isHidden());
	cfg->writeEntry("detailSize", m_detailSize);
	
	// Search View
	// TODO: MOVE!
	cfg->writeEntry("searchTitles", cb_searchtitles->isChecked());
	cfg->writeEntry("searchActors", cb_searchactors->isChecked());
	cfg->writeEntry("searchDesc", cb_searchdesc->isChecked());

	m_favouriteMaster->saveFavourites(cfg);
	m_blistMaster->saveBlacklist(cfg);
	m_parseMaster->saveCustomizedChannels();

	cfg->sync();
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::browseUpdateCmdClicked()
{
	QString fileName = KFileDialog::getOpenFileName(NULL, "*.xml", this, i18n("Please choose XML TV-File to use..."));
	if(fileName == "" || fileName == QString::null) return;
	prefs()->le_tvfile->setText(fileName);
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::browseCommandClicked()
{
	QString fileName = KFileDialog::getOpenFileName(NULL, "*.*", this, i18n("Please choose Command to Execute..."));
	if(fileName == "" || fileName == QString::null) return;
	prefs()->le_command->setText(fileName);
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::aboutClicked()
{
	AboutDialog aboutDia;
	aboutDia.tl_version->setText("Maxemum TV-Guide v" + QString::fromLatin1(VERSION) + QString::fromLatin1(VERSION_EXT));
	aboutDia.exec();
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::parse()
{
// TODO: Traverse ALL views with preparse()!
	m_programView->preParse();
	m_searchView->preParse();
	m_completeView->preParse();
	lv_channel->clear();

// TODO: use return value from parser!
	m_parseMaster->parse(prefs()->le_tvfile->text());	// programs and channels are replaced
	postParse();

// TODO: Traverse ALL views with reparsed(), not just m_programView!
	m_programView->postParse();
	m_searchView->postParse();
	m_completeView->postParse();
	m_channelView->update();

// TODO: Move this to a more appropriate place
	rebuildCategories();

	QTime now(QTime::currentTime());
	m_timer->changeInterval((60-now.second())*1000);
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::rebuild(bool forceDownload)
{
	if(forceDownload) {
		downloadListings();
		parse();
		activeView()->rebuild();
//		if(m_parseMaster->futureDates() < 0)
	}

	if(prefs()->cb_autoupdate->isChecked() && m_parseMaster->futureDates() < 0) {
		downloadListings(true); // auto close
		parse();
		activeView()->rebuild();
	}

	if(m_blockUpdate || activeView()->refresh() || activeView()->rebuild())
		return;
	parse();
	if(activeView()->rebuild()) {
		return;
	}
	if(prefs()->cb_autoupdate->isChecked()) {
		downloadListings(true);
		parse();
		if(!activeView()->rebuild()) {
			KMessageBox::information(0, i18n("Couldn't find any data to process. Check your XML TV-File..."));
			m_timer->stop();
		}
	} else {
//		KMessageBox::information(0, "Couldn't find any data to process. You probably need to update.");
		m_timer->stop();
	}
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::refresh()
{
	activeView()->refresh();
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::downloadListings(bool autoClose)
{
	UpdateDialog updia(autoClose, isShown(), VERSION, prefs()->le_updatecmd->text());
	updia.exec();
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::timerDone()
{
	QTime now(QTime::currentTime());

	if(now.hour() == 0 && now.minute() == 0) {
		if(prefs()->cb_autoupdate->isChecked() && m_parseMaster->futureDates() < 0) {
			downloadListings(true);
			parse();
			activeView()->rebuild();
		} else {
// TODO: Traverse ALL views with newDay()!
			m_programView->newDay();
			m_searchView->newDay();
			m_completeView->newDay();
		}
	}
	if(now.hour() == prefs()->cb_daystart->currentItem() && now.minute() == 0)
		m_programView->daystartPassed();

	refresh();
	
	if(prefs()->cb_showpopup->isChecked() || prefs()->cb_executecmd->isChecked())
		m_favouriteMaster->showReminder(m_parseMaster->programs(), prefs()->cb_showpopup->isChecked(), prefs()->cb_executecmd->isChecked());

	m_timer->changeInterval((60-now.second())*1000);
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::rebuildView()
{
	if(prefs()->cb_autoupdate->isChecked() && (prefs()->cb_daystart->currentItem() > 0 && m_parseMaster->futureDates() < 1)) {
		downloadListings(true);
		parse();
	}
	m_programView->rebuild();
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::defaultColoursClicked()
{
	QColor col(255, 240, 240);
	m_blockUpdate = true;
	prefs()->kcb_past->setColor(col);
	col.setRgb(255, 255, 240);
	prefs()->kcb_present->setColor(col);
	col.setRgb(246, 238, 150);
	prefs()->kcb_progress->setColor(col);
	col.setRgb(240, 255, 240);
	prefs()->kcb_future->setColor(col);
	col.setRgb(240, 240, 255);
	prefs()->kcb_favourite->setColor(col);
	col.setRgb(140, 140, 140);
	prefs()->kcb_timesep->setColor(col);
	col.setRgb(200, 200, 200);
	prefs()->kcb_colsep->setColor(col);
	m_blockUpdate = false;
	refresh();
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::capturedShortcut(const KShortcut &sc)
{
	m_globalAccel.remove("Toggle");
	if(!sc.isNull()) {
		m_globalAccel.insert("Toggle", "Toggle", "Toggle Mainwindow", sc, sc, m_parent, SLOT(doToggle()));
		m_globalAccel.updateConnections();
	}
	prefs()->kkb_toggle->setShortcut(sc, true);
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::manualColWidth(bool manual)
{
// TODO: Traverse!
	if(manual) {
		lv_program->setColumnWidthMode(1, QListView::Manual);
		lv_program->setColumnWidth(1, m_programView->showColWidth());
		lv_search->setColumnWidthMode(1, QListView::Manual);
		lv_search->setColumnWidth(1, m_searchView->showColWidth());
		lv_complete->setColumnWidthMode(1, QListView::Manual);
		lv_complete->setColumnWidth(1, m_completeView->showColWidth());
	} else {
		lv_program->setColumnWidthMode(1, QListView::Maximum);
		lv_search->setColumnWidthMode(1, QListView::Maximum);
		lv_complete->setColumnWidthMode(1, QListView::Maximum);
	}
	refresh();
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::toggleDetails()
{
	if(d_frame->isHidden()) {
		d_frame->show();
		splitterh->setSizes(m_detailSize);
	} else {
		m_detailSize = splitterh->sizes();
		d_frame->hide();
	}
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::wireHotkeys()
{
	new KAction("Day View", Key_F1, this, SLOT(switchToDayView()), &m_actionCollection, "dayview");
	new KAction("Full View", Key_F2, this, SLOT(switchToFullView()), &m_actionCollection, "fullview");
	new KAction("Search View", Key_F3, this, SLOT(switchToSearchView()), &m_actionCollection, "searchview");
	new KAction("Forum", Key_F4, this, SLOT(switchToForum()), &m_actionCollection, "forum");
	new KAction("Toggle Favourite", Key_Space, m_favouriteMaster, SLOT(toggleFavourite()), &m_actionCollection, "toggleFavourite");
	new KAction("Toggle Hide Past", CTRL+Key_H, this, SLOT(toggleHidePast()), &m_actionCollection, "toggleHidePast");
	new KAction("Toggle Favs Only", CTRL+Key_F, this, SLOT(toggleFavsOnly()), &m_actionCollection, "toggleFavsOnly");
	new KAction("Blacklist", CTRL+Key_B, m_blistMaster, SLOT(addBlacklist()), &m_actionCollection, "blackList");
	new KAction("Rebuild", Key_F5, this, SLOT(rebuild()), &m_actionCollection, "rebuild");
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::rebuildCategories() // TODO: Move this to a more appropriate place
{
	QStringList *cats = m_parseMaster->categories();
	QStringList::Iterator it = cats->begin();
	lv_category->clear();
	
	while(it != cats->end()) {
		new QListViewItem(lv_category, *it);
		++it;
	}
}
//-----------------------------------------------------------------------------------------------------------------------
BaseView* MainWidget::activeView()
{
	if(ws_main->visibleWidget() == Browse)
		return(m_programView);
	if(ws_main->visibleWidget() == Complete)
		return(m_completeView);
	if(ws_main->visibleWidget() == Search)
		return(m_searchView);
	return(m_forumView);
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::prefsClicked()
{
	m_prefsDialog.exec();
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::newUserCheck()
{
	NewUserDialog newUserDialog;

	if((prefs()->le_tvfile->text()).isEmpty())
		newUserDialog.exec();
}
//-----------------------------------------------------------------------------------------------------------------------
void MainWidget::postParse()
{
	QPtrListIterator<Program> it(*(m_parseMaster->programs()));
	Program *program;

	if(prefs()->sb_timeoffset->value() != 0)
		while(it.current()) {
			program = (Program*)it.current();
			program->setStartDT(program->startDT().addSecs(prefs()->sb_timeoffset->value()*3600));
			program->setStopDT(program->stopDT().addSecs(prefs()->sb_timeoffset->value()*3600));
			++it;
		}
}
//-----------------------------------------------------------------------------------------------------------------------
