/***************************************************************************
 *   Copyright (C) 2005-2006 by Robert Maxe                                *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#ifndef __CHANNELVIEW_H__
#define __CHANNELVIEW_H__
//-----------------------------------------------------------------------------------------------------------------------
#include <klistview.h>
#include <qcursor.h>
//-----------------------------------------------------------------------------------------------------------------------
class MainWidget;
//-----------------------------------------------------------------------------------------------------------------------
class ChannelView : public QObject
{
	Q_OBJECT
public:
	ChannelView(MainWidget *parent, KListView *lv);

	void update();

public slots:
	void showPopupMenu(KListView*, QListViewItem*, const QPoint&);
	void restoreName();
	void renameChannel();
	void channelSortMode(bool isOn);
	void customImage();
	void defaultImage();

private:
	MainWidget *m_parent;
	KListView *m_lv;

};
//-----------------------------------------------------------------------------------------------------------------------
#endif
//-----------------------------------------------------------------------------------------------------------------------
