(* Copyright (C) 2004-2005, HELM Team.
 * 
 * This file is part of HELM, an Hypertextual, Electronic
 * Library of Mathematics, developed at the Computer Science
 * Department, University of Bologna, Italy.
 * 
 * HELM is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * HELM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HELM; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA  02111-1307, USA.
 * 
 * For details, see the HELM World-Wide-Web page,
 * http://helm.cs.unibo.it/
 *)

exception Cancel

type abouts = [ `Blank | `Current_proof | `Us | `Coercions | `CoercionsFull]

type mathViewer_entry =
  [ `About of abouts
  | `Check of string
  | `Cic of Cic.term * Cic.metasenv
  | `Development of string
  | `Dir of string
  | `HBugs of [ `Tutors ]
  | `Metadata of [ `Deps of [`Fwd | `Back] * UriManager.uri ]
  | `Uri of UriManager.uri
  | `Whelp of string * UriManager.uri list ]

val string_of_entry : mathViewer_entry -> string
val entry_of_string : string -> mathViewer_entry

class type mathViewer =
  object
    method show_entry : ?reuse:bool -> mathViewer_entry -> unit
    method show_uri_list :
      ?reuse:bool -> entry:mathViewer_entry -> UriManager.uri list -> unit
  end
