(* Copyright (C) 2000, HELM Team.
 * 
 * This file is part of HELM, an Hypertextual, Electronic
 * Library of Mathematics, developed at the Computer Science
 * Department, University of Bologna, Italy.
 * 
 * HELM is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * HELM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HELM; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA  02111-1307, USA.
 * 
 * For details, see the HELM World-Wide-Web page,
 * http://cs.unibo.it/helm/.
 *)

(* $Id: unshare.ml 7922 2007-11-25 13:12:25Z tassi $ *)

let rec unshare =
 let module C = Cic in
  function
     C.Rel m -> C.Rel m
   | C.Var (uri,exp_named_subst) ->
      let exp_named_subst' = 
       List.map (function (uri,t) -> (uri,unshare t)) exp_named_subst
      in
       C.Var (uri,exp_named_subst')
   | C.Meta (i,l) ->
      let l' =
       List.map
        (function
            None -> None
          | Some t -> Some (unshare t)
        ) l
      in
       C.Meta(i,l')
   | C.Sort s -> C.Sort s
   | C.Implicit info -> C.Implicit info
   | C.Cast (te,ty) -> C.Cast (unshare te, unshare ty)
   | C.Prod (n,s,t) -> C.Prod (n, unshare s, unshare t)
   | C.Lambda (n,s,t) -> C.Lambda (n, unshare s, unshare t)
   | C.LetIn (n,s,t) -> C.LetIn (n, unshare s, unshare t)
   | C.Appl l -> C.Appl (List.map unshare l)
   | C.Const (uri,exp_named_subst) ->
      let exp_named_subst' = 
       List.map (function (uri,t) -> (uri,unshare t)) exp_named_subst
      in
       C.Const (uri,exp_named_subst')
   | C.MutInd (uri,tyno,exp_named_subst) ->
      let exp_named_subst' = 
       List.map (function (uri,t) -> (uri,unshare t)) exp_named_subst
      in
       C.MutInd (uri,tyno,exp_named_subst')
   | C.MutConstruct (uri,tyno,consno,exp_named_subst) ->
      let exp_named_subst' = 
       List.map (function (uri,t) -> (uri,unshare t)) exp_named_subst
      in
       C.MutConstruct (uri,tyno,consno,exp_named_subst')
   | C.MutCase (sp,i,outty,t,pl) ->
      C.MutCase (sp, i, unshare outty, unshare t,
       List.map unshare pl)
   | C.Fix (i, fl) ->
      let liftedfl =
       List.map
        (fun (name, i, ty, bo) -> (name, i, unshare ty, unshare bo))
         fl
      in
       C.Fix (i, liftedfl)
   | C.CoFix (i, fl) ->
      let liftedfl =
       List.map
        (fun (name, ty, bo) -> (name, unshare ty, unshare bo))
         fl
      in
       C.CoFix (i, liftedfl)
