#! /usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (c)2004, Matthias A. Benkard.
  
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from core.common import _

import logging
import wx
from wx import xrc

log = logging.getLogger("wxgui.util")

_signal_mappings = {
	'menu': wx.EVT_MENU,
	'clicked': wx.EVT_BUTTON,
	'tool': wx.EVT_TOOL
}

def signal_autoconnect(frame):
	global _signal_mappings
	
	for rawname in dir(frame):
		if rawname[:3] == "on_":
			name = rawname[3:]
			sig_delim = name.rfind("_")
			
			if not sig_delim == -1:
				signal = name[sig_delim + 1:]
				objname = name[:sig_delim]
				handler = getattr(frame, rawname)
				
				if signal in _signal_mappings:
					_signal_mappings[signal](frame, xrc.XRCID(objname), handler)
				else:
					log.warn(_("Signal \"%(signal)s\" for object \"%(object)s\" not found.") %
							{ "signal": signal, "object": objname })

