#! /usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright 2003, Matthias A. Benkard.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


from gui import MainWindow

from core import common
from core.common import _

import logging
import gettext
import gtk
import time
import sys

log = logging.getLogger("gui")

class GUILogHandler(logging.Handler):
	"""A handler for severe errors that notifies the user via a dialog box."""
	
	def __init__(self, parent_window = None, level = logging.ERROR):
		logging.Handler.__init__(self, level)
		self.parent_window = parent_window
	
	def emit(self, record):
		dialog = gtk.MessageDialog(self.parent_window,
				gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
				gtk.MESSAGE_ERROR, gtk.BUTTONS_OK,
				_("Logger '%(name)s' reports an error of "
				  "severity '%(severity)s':\n%(msg)s\n\n"
				  "Exception:\n%(exception)s") % {
					"name": record.name,
					"severity": record.levelname,
					"msg": record.msg % record.args,
					"exception": record.exc_info
				})
		dialog.run()
		dialog.destroy()


def init_styles():
	pass
#	common.bgcolor = gdk.Color(0xffffff)
#	common.fgcolor = gdk.Color(0x000000)


def sleeper():
	time.sleep(.001)
	return gtk.TRUE


def main():
	handler = GUILogHandler()
	log.addHandler(handler)
	
	init_styles()
	
	gtk.threads_init()
	# Whether this is necessary with PyGTK2 is
	# yet to be tested.
	if sys.platform == 'win32':
		print "Adding timeout hack."
		gtk.timeout_add(200, sleeper)
	
	app = MainWindow()
	gtk.threads_enter()
	gtk.mainloop()
	gtk.threads_leave()


if __name__ == '__main__':
	main()

