/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef _ANX_MIXER_H
#define _ANX_MIXER_H

#define MAX_NAME_LEN            256 /* max. length of channel names */

/* mixer channel direction types */
#define MIX_CHANNEL_BUS  0
#define MIX_CHANNEL_IN   1
#define MIX_CHANNEL_OUT  2

struct mixer_channel
{
    /*
     * left and right are in gain decibels * 10.  examples:
     *
     * -600 is  -60dB (60dB of attenuation)
     * +100 is  +10dB (10dB of gain)
     *    0 is    0dB (unity gain)
     * -002 is -0.2dB (0.2dB of attenuation)
     * 
     *   I used ints here to avoid floating point roundoff errors.
     */
    int16 left;
    int16 right;
    int is_stereo; /* if set, "left" holds the volume */
    int32 portnum; /* will be -1 if it doesn't correspond to a port */
    char name[MAX_NAME_LEN];
    int  iodir;
    int  recsrc;
};

extern int16 linear_to_dbvol( int16 lvol );
extern int16 dbvol_to_linear( int16 dbvol );
extern int32 add_mix_channel(struct mixer_channel* mch, char* name, int32 portnum, int mixer_channels );

#endif /* _ANX_MIXER_H */
