'\"
'\" Copyright (c) 1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: package.n,v 1.2 2003/11/24 05:09:59 bbbush Exp $
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: package.n,v 1.2 2003/11/24 05:09:59 bbbush Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH package n 7.5 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
package \- 装载包和版本控制的设施  
.SH "总览 SYNOPSIS"
.nf
\fBpackage forget ?\fIpackage package ...\fR?
\fBpackage ifneeded \fIpackage version\fR ?\fIscript\fR?
\fBpackage names\fR
\fBpackage present \fR?\fB\-exact\fR? \fIpackage \fR?\fIversion\fR?
\fBpackage provide \fIpackage \fR?\fIversion\fR?
\fBpackage require \fR?\fB\-exact\fR? \fIpackage \fR?\fIversion\fR?
\fBpackage unknown \fR?\fIcommand\fR?
\fBpackage vcompare \fIversion1 version2\fR
\fBpackage versions \fIpackage\fR
\fBpackage vsatisfies \fIversion1 version2\fR
.fi
.BE

.SH "描述 DESCRIPTION"
.PP
这个命令维持由当前解释器使用的可获得的包以及如何把它们装载到解释器中的一个简单的数据库。它支持每个包的多个版本，并基于应用的需要安排装载一个包的正确的版本。这个命令还检测并报告版本冲突。典型的，在通常的 Tcl 脚本中只调用 \fBpackage require\fR 和 \fBpackage provide\fR 命令；其他命令主要被系统脚本用来维护包数据库。
.PP
\fBpackage\fR 命令的行为由它的第一个参数确定。允许下列形式:    
.TP
\fBpackage forget ?\fIpackage package ...\fR?
从这个解释器中删除关于每个指定的包的所有信息，包括由 \fBpackage ifneeded\fR 和 \fBpackage provide\fR 提供的信息。  
.TP
\fBpackage ifneeded \fIpackage version\fR ?\fIscript\fR?
这个命令典型的只出现在系统配置脚本中，被用来设置包数据库。若需要一个特定的包的一个特定的版本，它指示如果这个包的这个版本是可获得的，可通过执行  \fIscript\fR   来把这个包来增加到解释器上。脚本保存在一个数据库中，由随后的 \fBpackage require\fR 命令使用；典型的，\fIscript\fR   为在包中的命令设置自动装载(或直接调用 \fBload\fR  和/或 \fBsource\fR)，接着调用\fBpackage provide\fR  来指示这个包已经存在。在数据库中可以有一个单一的包的多个版本的信息。如果数据库已经包含了对 \fIpackage\fR 和 \fIversion\fR 的信息，则新 \fIscript\fR  替换现存的脚本。如果省略了 \fIscript\fR 参数，返回包 \fIpackage\fR 的版本 \fIversion\fR  的当前脚本，如果未对这个 \fIpackage\fR 和 \fIversion\fR 调用 \fBpackage ifneeded\fR  命令则返回一个空串。  
.TP
\fBpackage names\fR
返回在这个解释器中所有包的名字，为这些包提供了一个版本(通过 \fBpackage provide\fR)或可获得给它们的 \fBpackage ifneeded\fR  脚本。在列表中的元素的次序是任意的。
.TP
\fBpackage present \fR?\fB\-exact\fR? \fIpackage \fR?\fIversion\fR?
除了在包没有装载时它不尝试并装载它之外，这个命令等价于 \fBpackage require\fR。
.TP
\fBpackage provide \fIpackage \fR?\fIversion\fR?
调用这个命令来指示在这个解释器中包 \fIpackage\fR  的这个版本 \fIversion\fR  现在已经存在。它典型的被作为一个 \fBifneeded\fR脚本的一部分而调用一次，并在包最终装载时被包自身再次调用。如果以前的 \fBpackage provide\fR  命令已经提供的 \fIpackage\fR 的一个不同的版本则生成一个错误。如果省略了 \fIversion\fR  参数，则命令返回当前提供包的版本号，如果在这个解释器中对 \fIpackage\fR 没有调用 \fBpackage provide\fR 命令则返回一个空串。
.TP
\fBpackage require \fR?\fB\-exact\fR? \fIpackage \fR?\fIversion\fR?
这个命令典型的被想要使用特定包的特定版本的 Tcl 脚本调用。参数指示想要哪个包，和确保把包的合适版本装载到解释器中的命令。如果命令成功执行，它返回装载的包的版本号；否则生成一个错误。如果同时指定了 \fB-exact\fR  开关和 \fIversion\fR  选项，则只接受给定版本。如果省略了 \fB-exact\fR 但指定了 \fIversion\fR  ，则主版本号与 \fIversion \fR相同但晚于 \fIversion\fR 的版本也可以接受。如果省略了 \fB-exact\fR  和 \fIversion\fR二者则任何版本都可接受。如果已经提供了 \fIpackage\fR 的一个版本(通过调用 \fBpackage provide\fR  命令)，则它的版本号必须满足由\fB-exact\fR  和 \fIversion\fR  给出的条件并且命令立即返回。否则，命令查找由以前的\fBpackage ifneeded\fR 命令提供的信息的数据库，看是否能获得一个可接受的版本。如果有，则调用最可接受的版本号的脚本；它必须做所有装载这个包所必须的工作，包括调用为这个包调用 \fBpackage provide\fR。如果 \fBpackage ifneeded\fR数据库不包含这个包的可接受的版本并且为这个解释器指定了一个 \fBpackage unknown\fR 命令则调用这个命令；当它完成的时候，Tcl 再次检查是否现在提供了这个包或是否有一个给它的 \fBpackage ifneeded\fR脚本。如果所有这些步骤不能提供这个包的一个可接受的版本，则命令返回一个错误。 
.TP
\fBpackage unknown \fR?\fIcommand\fR?
这个命令提供在一个“最后一搏”(``last resort'') 命令，在 \fBpackage require\fR  期间如果 \fBpackage ifneeded\fR 数据库中没有一个包的合适的版本可调用这个命令。如果提供了 \fIcommand\fR 参数，它包含一个命令的第一部分，在一次 \fBpackage require\fR 命令期间调用这个命令的时候，Tcl  添加给出所须的包的名字和版本的两个附加参数。例如，如果 \fIcommand\fR是 \fBfoo bar\fR  并且后来调用了命令 \fBpackage require test 2.4\fR，则 Tcl 将执行命令 \fBfoo bar test 2.4\fR  来装载这个包。如果未给 \fBpackage require\fR  命令提供版本号，则给这个被调用的命令的版本参数是一个空串。如果 \fBpackage unknown\fR命令但不加 \fIcommand\fR 参数，则返回当前的 \fBpackage unknown\fR 脚本，如果没有就返回一个空串。如果指定 \fIcommand\fR   为一个空串，若当前有  \fBpackage unknown\fR  脚本则删除它。  
.TP
\fBpackage vcompare \fIversion1 version2\fR
比较由 \fIversion1\fR和 \fIversion2 \fR给出的两个版本。如果 \fIversion1\fR 比 \fIversion2 \fR早就返回 -1，如果相同则返回0，如果 \fIversion1\fR 比 \fIversion2 \fR晚则返回 1。
.TP
\fBpackage versions \fIpackage\fR
返回 \fIpackage\fR  的所有版本号，通过 \fBpackage ifneeded\fR  命令为它们提供了信息。   
.TP
\fBpackage vsatisfies \fIversion1 version2\fR
如果为 \fIversion2\fR  写的脚本不须更改就可为 \fIversion1\fR   工作则返回 1(例如，\fIversion1\fR  大于等于 \fIversion2\fR   并且有相同的主版本号)，否则返回 0。

.SH "版本号 VERSION NUMBERS"
.PP
版本号由一个或多个用点号分隔的十进制数组成，比如 2 或 1.162  
或 3.1.13.1。第一个数叫做主版本号。越大的数对应一个包的越晚的版本，最左边的数有更大的权重(significance).  
例如，版本 2.1 比 1.3 晚而版本         
3.4.6 比 3.3.5 晚。遗漏的字段等价于零: 版本 1.3 于版本 1.3.0  
和 1.3.0.0 相同，所以它比 1.3.1 和 1.3.0.2  
早。假定一个晚期版本向上(upward)兼容有相同主版本号的早期版本。
例如，为一个包的版本 2.3  
写的 Tcl 脚本应当在版本 2.3.2、2.4、和 2.5.1  
下不须更改就能工作。主版本号的变更表示有不兼容的变更:  
如果代码是使用了一个包的版本 2.1 写成的，不保证在版本 1.7.3  
或版本 3.1 下不须更改就能工作。        

.SH "包索引 PACKAGE INDICES"
.PP
推荐的在 Tcl 中使用包的方式是在脚本中调用 \fBpackage require\fR  和 \fBpackage provide\fR  命令，并使用过程 \fBpkg_mkIndex\fR  来建立包索引文件。一旦你已经这样做了，将自动的装载包来响应  \fBpackage require\fR 命令。详情请参见 \fBpkg_mkIndex\fR  的文档。

.SH "参见 SEE ALSO"
msgcat(n), packagens(n), pkgMkIndex(n)

.SH "关键字 KEYWORDS"
package, version

.SH "[中文版维护人]"
.B 寒蝉退士
.SH "[中文版最新更新]"
.B 2001/08/31
.SH "《中国 Linux 论坛 man 手册页翻译计划》:"
.BI http://cmpp.linuxforum.net
