/*
                              Manual Page Editor
 */

#ifndef MANEDIT_H
#define MANEDIT_H

#if defined(_AIX)
# include <stdlib.h>
# include <strings.h>
#endif

#include <gtk/gtk.h>

#include "fb.h"

#include "editor.h"
#include "viewer.h"
#include "pref.h"
#include "aboutdialog.h"


/*
 *	Global marker to close all windows if set to TRUE:
 */
extern gboolean		need_close_all_windows;

/*
 *	Global switch to use gtk_text_*() function for GtkText widget
 *	text deleting instead of gtk_editable_*() functions.
 */
extern gboolean		use_text_delete;


/*
 *	Pointer Cursors:
 */
typedef struct {

	GdkCursor	*busy,
			*text;

} medit_cursors_list_struct;

/*
 *	Styles:
 */
typedef struct {

	/* Each style contains a loaded GdkFont and allocated colors.
	 * Each loaded GdkFont will have a ref count of atleast one
	 */
	GtkStyle	*standard,		/* Do not unref, this comes
						 * from GTK internal */
			*heading1_text,
			*heading2_text,
			*heading3_text,
			*heading4_text,
			*heading5_text,
			*heading6_text,

			*heading1_rev_text,
			*heading2_rev_text,
			*heading3_rev_text,
			*heading4_rev_text,

			*edit_text_standard,	/* Standard */
			*edit_text_background,	/* Background */
			*edit_text_tag_deliminator,	/* Tag deliminator */
			*edit_text_tag_text,	/* Tag text */
			*edit_text_tag_symrep,	/* Symbol representation */
			*manpage_text_standard,	/* Manpage output std */
			*manpage_text_background,	/* Manpage bg */
			*manpage_text_bold,	/* Manpage output bold */
			*manpage_text_underline;	/* Manpage output underline */

} medit_styles_list_struct;

/*
 *	Pixmaps list structure:
 */
typedef struct {

	GdkPixmap	*medit_icon_48x48;
	GdkBitmap	*medit_icon_48x48_mask;

	/* Icons for list items */
	GdkPixmap       *folder_closed_20x20;
	GdkBitmap       *folder_closed_20x20_mask;

        GdkPixmap       *folder_opened_20x20;
        GdkBitmap       *folder_opened_20x20_mask;

	GdkPixmap	*manual_closed_20x20;
	GdkBitmap	*manual_closed_20x20_mask;

	GdkPixmap	*manual_opened_20x20;
	GdkBitmap	*manual_opened_20x20_mask;

	GdkPixmap	*manpage_heading_20x20;
	GdkBitmap	*manpage_heading_20x20_mask;

	GdkPixmap	*manpage_section_20x20;
	GdkBitmap	*manpage_section_20x20_mask;

} medit_pixmaps_list_struct;

/*
 *	ManEdit Core:
 */
struct _medit_core_struct {

	gint		untitled_count;

	guint		toid;			/* Main timeout callback id */

	GdkAtom		string_atom;

	medit_cursors_list_struct	cursors_list;
	medit_styles_list_struct	styles_list;
	medit_pixmaps_list_struct	pixmaps_list;

	/* Need to add file paths here */

	/* Editors */
	editor_struct	**editor;
	gint		total_editors;

	/* Viewers */
	viewer_struct	**viewer;
	gint		total_viewers;

	/* Preferences window */
	pref_struct	*pref;

	/* About dialog  */
	about_dialog_struct	*about;

};

extern medit_core_struct	*medit_core_ptr;


extern medit_core_struct *MEditNew(
	gint argc, gchar **argv,
	gint *status_rtn
);
extern void MEditDelete(medit_core_struct *core);


#endif	/* MANEDIT_H */
