<?php
/**
 * Mahara: Electronic portfolio, weblog, resume builder and social networking
 * Copyright (C) 2011 Catalyst IT Ltd and others; see:
 *                         http://wiki.mahara.org/Contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package    mahara
 * @subpackage core
 * @author     Stacey Walker
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL
 * @copyright  (C) 2011 Catalyst IT Ltd http://catalyst.net.nz
 *
 */

define('INTERNAL', 1);
define('INSTITUTIONALADMIN', 1);
require(dirname(dirname(dirname(__FILE__))) . '/init.php');
define('SECTION_PLUGINTYPE', 'core');
define('SECTION_PLUGINNAME', 'admin');
define('SECTION_PAGE', 'actionregistration');
require_once('pieforms/pieform.php');
require_once('institution.php');

$id = param_integer('r');
$action = param_alpha('action');

if (!is_logged_in()) {
    throw new AccessDeniedException();
}

if (!$registration = get_record_select('usr_registration', '"id" = ? AND pending = 1', array($id))) {
    die_info(get_string('registrationnosuchkey', 'auth.internal'));
}
if (!$inst = get_record('institution', 'name', $registration->institution)) {
    die_info(get_string('nosuchinstitution', 'admin'));
}

if ($action == 'approve') {
    $message = get_string('approveregistrationmessage', 'admin', $inst->displayname);
}
else {
    $message = get_string('denyregistrationmessage', 'admin');
}

if ($action == 'approve') {
    $submitbtn = get_string('approve', 'admin');
}
else {
    $submitbtn = get_string('deny', 'admin');
}

define('TITLE', get_string($action.'registrationfor', 'admin', $registration->firstname, $registration->lastname));

if ($action !== 'approve') {
    $elements['message'] = array(
        'type'  => 'textarea',
        'title' => get_string('registrationdeniedreason', 'admin'),
        'description' => get_string('registrationdeniedreasondesc', 'admin'),
        'cols' => 50,
        'rows' => 10,
    );
}
foreach ((array)$registration as $key => $value) {
    $elements[$key] = array(
        'type'  => 'hidden',
        'value' => $value,
    );
}
$elements['submit'] = array(
    'type' => 'submitcancel',
    'value' => array($submitbtn, get_string('cancel')),
    'goto' => get_config('wwwroot') . 'admin/users/pendingregistrations.php?institution='.$inst->name,
);

$form = pieform(array(
    'name' => $action.'registration',
    'autofocus' => false,
    'method' => 'post',
    'elements' => $elements,
));

$smarty = smarty();
$smarty->assign('PAGEHEADING', TITLE);
$smarty->assign('message', $message);
$smarty->assign('form', $form);
$smarty->display('admin/users/actionregistration.tpl');

function denyregistration_submit(Pieform $form, $values) {
    global $USER, $SESSION;

    if (isset($values['message']) && !empty($values['message'])) {
        $message = get_string('registrationdeniedmessagereason', 'auth.internal',
            $values['firstname'], get_config('sitename'), $values['message'], display_name($USER));
    }
    else {
        $message = get_string('registrationdeniedmessage', 'auth.internal',
            $values['firstname'], get_config('sitename'), display_name($USER));
    }
    try {
        delete_records('usr_registration', 'email', $values['email']);

        $user = (object) $values;
        $user->admin = 0;
        $user->staff = 0;
        email_user($user, $USER,
            get_string('registrationdeniedemailsubject', 'auth.internal', get_config('sitename')),
            $message
        );
    }
    catch (EmailException $e) {
        log_warn($e);
        die_info(get_string('registrationdeniedunsuccessful', 'admin'));
    }
    catch (SQLException $e) {
        log_warn($e);
        die_info(get_string('registrationdeniedunsuccessful', 'admin'));
    }

    $SESSION->add_ok_msg(get_string('registrationdeniedsuccessful', 'admin'));
    redirect('/admin/users/pendingregistrations.php?institution='.$values['institution']);
}

function approveregistration_submit(Pieform $form, $values) {
    global $SESSION;

    // update expiry time and set pending to a value that identify
    // it as approved (2)
    $values['pending'] = 2;
    $values['expiry'] = db_format_timestamp(time() + 86400); // now + 1 day
    update_record('usr_registration', $values, array('email' => $values['email']));

    // send the user the official account completion email
    $user = (object) $values;
    $user->admin = 0;
    $user->staff = 0;
    email_user($user, null,
        get_string('registeredemailsubject', 'auth.internal', get_config('sitename')),
        get_string('registeredemailmessagetext', 'auth.internal',
            $user->firstname, get_config('sitename'), get_config('wwwroot'),
            $user->key, get_config('sitename')),
        get_string('registeredemailmessagehtml', 'auth.internal',
            $user->firstname, get_config('sitename'), get_config('wwwroot'),
            $user->key, get_config('wwwroot'), $user->key, get_config('sitename'))
        );

    $SESSION->add_ok_msg(get_string('registrationapprovedsuccessfully', 'admin'));
    redirect('/admin/users/pendingregistrations.php?institution='.$user->institution);
}
